/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.cloner;

import ai.timefold.solver.core.impl.domain.solution.cloner.FieldCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.ShallowCloningPrimitiveFieldCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.ShallowCloningReferenceFieldCloner;
import java.lang.reflect.Field;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface ShallowCloningFieldCloner {
    public static ShallowCloningFieldCloner of(Field field) {
        Class<?> fieldType = field.getType();
        if (fieldType == Boolean.TYPE) {
            return new ShallowCloningPrimitiveFieldCloner(field, FieldCloningUtils::copyBoolean);
        }
        if (fieldType == Byte.TYPE) {
            return new ShallowCloningPrimitiveFieldCloner(field, FieldCloningUtils::copyByte);
        }
        if (fieldType == Character.TYPE) {
            return new ShallowCloningPrimitiveFieldCloner(field, FieldCloningUtils::copyChar);
        }
        if (fieldType == Short.TYPE) {
            return new ShallowCloningPrimitiveFieldCloner(field, FieldCloningUtils::copyShort);
        }
        if (fieldType == Integer.TYPE) {
            return new ShallowCloningPrimitiveFieldCloner(field, FieldCloningUtils::copyInt);
        }
        if (fieldType == Long.TYPE) {
            return new ShallowCloningPrimitiveFieldCloner(field, FieldCloningUtils::copyLong);
        }
        if (fieldType == Float.TYPE) {
            return new ShallowCloningPrimitiveFieldCloner(field, FieldCloningUtils::copyFloat);
        }
        if (fieldType == Double.TYPE) {
            return new ShallowCloningPrimitiveFieldCloner(field, FieldCloningUtils::copyDouble);
        }
        return new ShallowCloningReferenceFieldCloner(field, FieldCloningUtils::copyObject);
    }

    public <C> void clone(C var1, C var2);
}

