/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.descriptor;

import ai.timefold.solver.core.preview.api.domain.metamodel.GenuineVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningEntityMetaModel;
import ai.timefold.solver.core.preview.api.domain.solution.diff.PlanningEntityDiff;
import ai.timefold.solver.core.preview.api.domain.solution.diff.PlanningSolutionDiff;
import ai.timefold.solver.core.preview.api.domain.solution.diff.PlanningVariableDiff;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
record DefaultPlanningEntityDiff<Solution_, Entity_>(PlanningSolutionDiff<Solution_> solutionDiff, Entity_ entity, PlanningEntityMetaModel<Solution_, Entity_> entityMetaModel, Map<String, PlanningVariableDiff<Solution_, Entity_, ?>> variableDiffMap) implements PlanningEntityDiff<Solution_, Entity_>
{
    DefaultPlanningEntityDiff(PlanningSolutionDiff<Solution_> solutionDiff, Entity_ entity) {
        this(solutionDiff, entity, solutionDiff.solutionMetaModel().entity(entity.getClass()));
    }

    DefaultPlanningEntityDiff(PlanningSolutionDiff<Solution_> solutionDiff, Entity_ entity, PlanningEntityMetaModel<Solution_, Entity_> entityMetaModel) {
        this(solutionDiff, entity, entityMetaModel, new LinkedHashMap(entityMetaModel.variables().size()));
    }

    @Override
    public <Value_> PlanningVariableDiff<Solution_, Entity_, Value_> variableDiff() {
        if (this.variableDiffMap.size() != 1) {
            throw new IllegalStateException("There is more than one planning variable (%s) on the planning entity (%s).\nUse variableDiff(String) instead.".formatted(this.variableDiffMap.keySet(), this.entity.getClass()));
        }
        return this.variableDiffs().iterator().next();
    }

    void addVariableDiff(PlanningVariableDiff<Solution_, Entity_, ?> variableDiff) {
        this.variableDiffMap.put(variableDiff.variableMetaModel().name(), variableDiff);
    }

    @Override
    public <Value_> @Nullable PlanningVariableDiff<Solution_, Entity_, Value_> variableDiff(String variableRef) {
        return this.variableDiffMap.get(variableRef);
    }

    @Override
    public Collection<PlanningVariableDiff<Solution_, Entity_, ?>> variableDiffs() {
        return Collections.unmodifiableCollection(this.variableDiffMap.values());
    }

    @Override
    public String toString() {
        return "Difference between two solutions in variable(s) of planning entity (%s) of type (%s):\n%s\n".formatted(this.entity, this.entityMetaModel().type(), DefaultPlanningEntityDiff.entityDiffToString(this));
    }

    private static String entityDiffToString(PlanningEntityDiff<?, ?> entityDiff) {
        Collection<PlanningVariableDiff<?, ?, ?>> variableDiffs = entityDiff.variableDiffs();
        if (variableDiffs.size() == 1) {
            PlanningVariableDiff<?, ?, ?> diff2 = variableDiffs.iterator().next();
            return "  %s: %s -> %s".formatted(diff2.variableMetaModel().name(), diff2.oldValue(), diff2.newValue());
        }
        return variableDiffs.stream().map(diff -> "  %s (%s): %s -> %s".formatted(diff.variableMetaModel().name(), diff.variableMetaModel() instanceof GenuineVariableMetaModel ? "genuine" : "shadow", diff.oldValue(), diff.newValue())).collect(Collectors.joining(System.lineSeparator()));
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (!(o instanceof DefaultPlanningEntityDiff)) {
            return false;
        }
        DefaultPlanningEntityDiff that = (DefaultPlanningEntityDiff)o;
        return Objects.equals(this.entityMetaModel, that.entityMetaModel) && Objects.equals(this.solutionDiff, that.solutionDiff) && Objects.equals(this.entity, that.entity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityMetaModel, this.solutionDiff, this.entity);
    }
}

