/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.anchor;

import ai.timefold.solver.core.impl.domain.variable.BasicVariableChangeEvent;
import ai.timefold.solver.core.impl.domain.variable.anchor.AnchorVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.listener.SourcedBasicVariableListener;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ExternalizedAnchorVariableSupply<Solution_>
implements SourcedBasicVariableListener<Solution_, Object>,
AnchorVariableSupply {
    protected final VariableDescriptor<Solution_> previousVariableDescriptor;
    protected final SingletonInverseVariableSupply nextVariableSupply;
    protected final Map<Object, @Nullable Object> anchorMap;

    public ExternalizedAnchorVariableSupply(VariableDescriptor<Solution_> previousVariableDescriptor, SingletonInverseVariableSupply nextVariableSupply) {
        this.previousVariableDescriptor = previousVariableDescriptor;
        this.nextVariableSupply = nextVariableSupply;
        this.anchorMap = new IdentityHashMap<Object, Object>();
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.previousVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(InnerScoreDirector<Solution_, ?> scoreDirector) {
        this.anchorMap.clear();
        this.previousVariableDescriptor.getEntityDescriptor().visitAllEntities(scoreDirector.getWorkingSolution(), this::insert);
    }

    @Override
    public void beforeChange(InnerScoreDirector<Solution_, ?> scoreDirector, BasicVariableChangeEvent<Object> event) {
    }

    @Override
    public void afterChange(InnerScoreDirector<Solution_, ?> scoreDirector, BasicVariableChangeEvent<Object> event) {
        this.insert(event.entity());
    }

    @Override
    public void close() {
        this.anchorMap.clear();
    }

    protected void insert(Object entity) {
        Object previousEntity = this.previousVariableDescriptor.getValue(entity);
        Object anchor = previousEntity == null ? null : (this.previousVariableDescriptor.isValuePotentialAnchor(previousEntity) ? (Object)previousEntity : this.anchorMap.get(previousEntity));
        Object nextEntity = entity;
        while (nextEntity != null && this.anchorMap.get(nextEntity) != anchor) {
            this.anchorMap.put(nextEntity, anchor);
            nextEntity = this.nextVariableSupply.getInverseSingleton(nextEntity);
        }
    }

    @Override
    public @Nullable Object getAnchor(Object entity) {
        return this.anchorMap.get(entity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.previousVariableDescriptor.getVariableName() + ")";
    }
}

