/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.cascade;

import ai.timefold.solver.core.api.domain.variable.CascadingUpdateShadowVariable;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.VariableListenerWithSources;
import ai.timefold.solver.core.impl.domain.variable.supply.Demand;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class CascadingUpdateShadowVariableDescriptor<Solution_>
extends ShadowVariableDescriptor<Solution_> {
    private final List<ShadowVariableTarget<Solution_>> shadowVariableTargetList;
    private final List<VariableDescriptor<Solution_>> targetVariableDescriptorList = new ArrayList<VariableDescriptor<Solution_>>();
    private VariableDescriptor<Solution_> firstTargetVariableDescriptor;
    private MemberAccessor targetMethod;

    public CascadingUpdateShadowVariableDescriptor(int ordinal, EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(ordinal, entityDescriptor, variableMemberAccessor);
        this.shadowVariableTargetList = new ArrayList<ShadowVariableTarget<Solution_>>();
        this.addTargetVariable(entityDescriptor, variableMemberAccessor);
    }

    public void addTargetVariable(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        this.shadowVariableTargetList.add(new ShadowVariableTarget<Solution_>(entityDescriptor, variableMemberAccessor));
    }

    public String getTargetMethodName() {
        MemberAccessor variableMemberAccessor = this.shadowVariableTargetList.get(0).variableMemberAccessor();
        return Arrays.stream((CascadingUpdateShadowVariable[])variableMemberAccessor.getDeclaredAnnotationsByType(CascadingUpdateShadowVariable.class)).findFirst().map(CascadingUpdateShadowVariable::targetMethodName).orElseThrow(() -> new IllegalStateException("The entity %s is not annotated with @%s.".formatted(this.entityDescriptor.getEntityClass(), CascadingUpdateShadowVariable.class.getSimpleName())));
    }

    public boolean update(ScoreDirector<Solution_> scoreDirector, Object entity) {
        if (this.targetVariableDescriptorList.size() == 1) {
            return this.updateSingle(scoreDirector, entity);
        }
        return this.updateMultiple(scoreDirector, entity);
    }

    private boolean updateSingle(ScoreDirector<Solution_> scoreDirector, Object entity) {
        Object oldValue = this.firstTargetVariableDescriptor.getValue(entity);
        scoreDirector.beforeVariableChanged(entity, this.firstTargetVariableDescriptor.getVariableName());
        this.targetMethod.executeGetter(entity);
        Object newValue = this.firstTargetVariableDescriptor.getValue(entity);
        scoreDirector.afterVariableChanged(entity, this.firstTargetVariableDescriptor.getVariableName());
        return !Objects.equals(oldValue, newValue);
    }

    private boolean updateMultiple(ScoreDirector<Solution_> scoreDirector, Object entity) {
        ArrayList oldValueList = new ArrayList(this.targetVariableDescriptorList.size());
        for (VariableDescriptor<Solution_> targetVariableDescriptor : this.targetVariableDescriptorList) {
            scoreDirector.beforeVariableChanged(entity, targetVariableDescriptor.getVariableName());
            oldValueList.add(targetVariableDescriptor.getValue(entity));
        }
        this.targetMethod.executeGetter(entity);
        boolean hasChange = false;
        for (int i = 0; i < this.targetVariableDescriptorList.size(); ++i) {
            VariableDescriptor<Solution_> targetVariableDescriptor = this.targetVariableDescriptorList.get(i);
            Object newValue = targetVariableDescriptor.getValue(entity);
            scoreDirector.afterVariableChanged(entity, targetVariableDescriptor.getVariableName());
            if (hasChange || Objects.equals(oldValueList.get(i), newValue)) continue;
            hasChange = true;
        }
        return hasChange;
    }

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        for (ShadowVariableTarget<Solution_> shadowVariableTarget : this.shadowVariableTargetList) {
            this.targetVariableDescriptorList.add(shadowVariableTarget.entityDescriptor().getShadowVariableDescriptor(shadowVariableTarget.variableMemberAccessor().getName()));
        }
        List<GenuineVariableDescriptor> listVariableDescriptorList = this.entityDescriptor.getSolutionDescriptor().getEntityDescriptors().stream().flatMap(e -> e.getGenuineVariableDescriptorList().stream()).filter(VariableDescriptor::isListVariable).toList();
        if (listVariableDescriptorList.size() > 1) {
            throw new IllegalArgumentException("The shadow variable @%s does not support models with multiple planning list variables [%s].".formatted(CascadingUpdateShadowVariable.class.getSimpleName(), listVariableDescriptorList.stream().map(v -> v.getEntityDescriptor().getEntityClass().getSimpleName() + "::" + v.getVariableName()).collect(Collectors.joining(", "))));
        }
        String targetMethodName = this.getTargetMethodName();
        List<Member> allSourceMethodMembers = ConfigUtils.getDeclaredMembers(this.entityDescriptor.getEntityClass()).stream().filter(member -> {
            Method method;
            return member.getName().equals(targetMethodName) && member instanceof Method && (method = (Method)member).getParameterCount() == 0;
        }).toList();
        if (allSourceMethodMembers.isEmpty()) {
            throw new IllegalArgumentException("The entity class (%s) has an @%s annotated property (%s), but the method \"%s\" cannot be found.".formatted(this.entityDescriptor.getEntityClass(), CascadingUpdateShadowVariable.class.getSimpleName(), this.variableMemberAccessor.getName(), targetMethodName));
        }
        this.targetMethod = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(allSourceMethodMembers.get(0), MemberAccessorFactory.MemberAccessorType.VOID_METHOD, null, descriptorPolicy.getDomainAccessType());
        this.firstTargetVariableDescriptor = this.targetVariableDescriptorList.get(0);
    }

    @Override
    public List<VariableDescriptor<Solution_>> getSourceVariableDescriptorList() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Class<?>> getVariableListenerClasses() {
        return Collections.emptyList();
    }

    @Override
    public Demand<?> getProvidedDemand() {
        throw new UnsupportedOperationException("Cascade update element shadow variable cannot be demanded.");
    }

    @Override
    public boolean hasVariableListener() {
        return false;
    }

    @Override
    public boolean canBeUsedAsSource() {
        return false;
    }

    @Override
    public Iterable<VariableListenerWithSources> buildVariableListeners(SupplyManager supplyManager) {
        throw new UnsupportedOperationException("Cascade update element generates no listeners.");
    }

    @Override
    public boolean isListVariableSource() {
        return false;
    }

    private record ShadowVariableTarget<Solution_>(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
    }
}

