/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ExternalizedShadowVariableInconsistentProcessor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ShadowVariablesInconsistentVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import java.util.IdentityHashMap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class EntityConsistencyState<Solution_, Entity_> {
    private final IdentityHashMap<Entity_, Boolean> entityToIsInconsistentMap;
    private final @Nullable ExternalizedShadowVariableInconsistentProcessor<Solution_> externalizedShadowVariableInconsistentProcessor;
    private final VariableDescriptor<Solution_> arbitraryDeclarativeVariableDescriptor;

    EntityConsistencyState(EntityDescriptor<Solution_> entityDescriptor, IdentityHashMap<Entity_, Boolean> entityToIsInconsistentMap) {
        this.entityToIsInconsistentMap = entityToIsInconsistentMap;
        ShadowVariablesInconsistentVariableDescriptor<Solution_> entityIsInconsistentDescriptor = entityDescriptor.getShadowVariablesInconsistentDescriptor();
        if (entityIsInconsistentDescriptor == null) {
            this.externalizedShadowVariableInconsistentProcessor = null;
            this.arbitraryDeclarativeVariableDescriptor = entityDescriptor.getShadowVariableDescriptors().stream().filter(variableDescriptor -> variableDescriptor instanceof DeclarativeShadowVariableDescriptor).findFirst().orElseThrow(() -> new IllegalArgumentException("Impossible state: Entity class (%s) does not have any declarative variable descriptors.".formatted(entityDescriptor.getEntityClass())));
        } else {
            this.externalizedShadowVariableInconsistentProcessor = new ExternalizedShadowVariableInconsistentProcessor<Solution_>(entityIsInconsistentDescriptor);
            this.arbitraryDeclarativeVariableDescriptor = entityIsInconsistentDescriptor;
        }
    }

    public boolean isEntityConsistent(Entity_ entity) {
        return Boolean.FALSE.equals(this.entityToIsInconsistentMap.get(entity));
    }

    @Nullable Boolean getEntityInconsistentValue(Entity_ entity) {
        return this.entityToIsInconsistentMap.get(entity);
    }

    public void setEntityIsInconsistent(ChangedVariableNotifier<Solution_> changedVariableNotifier, Entity_ entity, boolean isInconsistent) {
        if (this.externalizedShadowVariableInconsistentProcessor != null) {
            this.externalizedShadowVariableInconsistentProcessor.setIsEntityInconsistent(changedVariableNotifier, entity, isInconsistent);
        }
        changedVariableNotifier.beforeVariableChanged().accept(this.arbitraryDeclarativeVariableDescriptor, entity);
        this.entityToIsInconsistentMap.put(entity, isInconsistent);
        changedVariableNotifier.afterVariableChanged().accept(this.arbitraryDeclarativeVariableDescriptor, entity);
    }

    @Nullable Boolean getEntityInconsistentValueFromProcessorOrNull(Entity_ entity) {
        if (this.externalizedShadowVariableInconsistentProcessor != null) {
            return this.externalizedShadowVariableInconsistentProcessor.getIsEntityInconsistent(entity);
        }
        return null;
    }

    public void setEntityIsInconsistentSkippingProcessor(Entity_ entity, boolean isInconsistent) {
        this.entityToIsInconsistentMap.put(entity, isInconsistent);
    }
}

