/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.BaseTopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.LoopedStatus;
import ai.timefold.solver.core.impl.util.DynamicIntArray;
import java.util.Arrays;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class LoopedTracker {
    private static final LoopedStatus[] VALUES = LoopedStatus.values();
    private final DynamicIntArray looped;
    private final int[][] entityIdToNodes;
    private final boolean[] entityInconsistentStatusChanged;

    public LoopedTracker(int nodeCount, int[][] entityIdToNodes) {
        this.entityIdToNodes = entityIdToNodes;
        this.entityInconsistentStatusChanged = new boolean[entityIdToNodes.length];
        this.looped = new DynamicIntArray(nodeCount, DynamicIntArray.ClearingStrategy.PARTIAL);
    }

    public void mark(int node, LoopedStatus status) {
        this.looped.set(node, status.ordinal());
    }

    public boolean isEntityInconsistent(BaseTopologicalOrderGraph graph, int entityId, @Nullable Boolean wasEntityInconsistent) {
        for (int entityNode : this.entityIdToNodes[entityId]) {
            if (!graph.isLooped(this, entityNode)) continue;
            if (wasEntityInconsistent == null || !wasEntityInconsistent.booleanValue()) {
                this.entityInconsistentStatusChanged[entityId] = true;
            }
            return true;
        }
        if (wasEntityInconsistent == null || wasEntityInconsistent.booleanValue()) {
            this.entityInconsistentStatusChanged[entityId] = true;
        }
        return false;
    }

    public boolean didEntityInconsistentStatusChange(int entityId) {
        return this.entityInconsistentStatusChanged[entityId];
    }

    public LoopedStatus status(int node) {
        return VALUES[this.looped.get(node)];
    }

    public void clear() {
        Arrays.fill(this.entityInconsistentStatusChanged, false);
        this.looped.clear();
    }
}

