/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.descriptor;

import ai.timefold.solver.core.api.domain.variable.PlanningVariable;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.List;

public abstract class VariableDescriptor<Solution_> {
    protected final int ordinal;
    protected final EntityDescriptor<Solution_> entityDescriptor;
    protected final MemberAccessor variableMemberAccessor;
    protected final String variableName;
    protected final String simpleEntityAndVariableName;
    protected VariableMetaModel<Solution_, ?, ?> cachedMetamodel = null;
    protected List<ShadowVariableDescriptor<Solution_>> sinkVariableDescriptorList = new ArrayList<ShadowVariableDescriptor<Solution_>>(4);

    protected VariableDescriptor(int ordinal, EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        this(ordinal, entityDescriptor, variableMemberAccessor, false);
    }

    protected VariableDescriptor(int ordinal, EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor, boolean allowPrimitive) {
        if (!allowPrimitive && variableMemberAccessor.getType().isPrimitive()) {
            throw new IllegalStateException("The entityClass (%s) has a @%s annotated member (%s) that returns a primitive type (%s).\nThis means it cannot represent an uninitialized variable as null and the Construction Heuristics think it's already initialized.\nMaybe let the member (%s) return its primitive wrapper type instead.".formatted(entityDescriptor.getEntityClass(), PlanningVariable.class.getSimpleName(), variableMemberAccessor, variableMemberAccessor.getType(), this.getSimpleEntityAndVariableName()));
        }
        this.ordinal = ordinal;
        this.entityDescriptor = entityDescriptor;
        this.variableMemberAccessor = variableMemberAccessor;
        this.variableName = variableMemberAccessor.getName();
        this.simpleEntityAndVariableName = entityDescriptor.getEntityClass().getSimpleName() + "." + this.variableName;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getSimpleEntityAndVariableName() {
        return this.simpleEntityAndVariableName;
    }

    public Class<?> getVariablePropertyType() {
        return this.variableMemberAccessor.getType();
    }

    public abstract void linkVariableDescriptors(DescriptorPolicy var1);

    public final boolean isListVariable() {
        return this instanceof ListVariableDescriptor;
    }

    public boolean canBeUsedAsSource() {
        return true;
    }

    public void registerSinkVariableDescriptor(ShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.sinkVariableDescriptorList.add(shadowVariableDescriptor);
    }

    public List<ShadowVariableDescriptor<Solution_>> getSinkVariableDescriptorList() {
        return this.sinkVariableDescriptorList;
    }

    public boolean isValuePotentialAnchor(Object value) {
        return !this.entityDescriptor.getEntityClass().isAssignableFrom(value.getClass());
    }

    public <Value_> Value_ getValue(Object entity) {
        return (Value_)this.variableMemberAccessor.executeGetter(entity);
    }

    public void setValue(Object entity, Object value) {
        this.variableMemberAccessor.executeSetter(entity, value);
    }

    public String getMemberAccessorSpeedNote() {
        return this.variableMemberAccessor.getSpeedNote();
    }

    public final boolean isGenuineAndUninitialized(Object entity) {
        GenuineVariableDescriptor genuineVariableDescriptor;
        VariableDescriptor variableDescriptor = this;
        return variableDescriptor instanceof GenuineVariableDescriptor && !(genuineVariableDescriptor = (GenuineVariableDescriptor)variableDescriptor).isInitialized(entity);
    }

    public VariableMetaModel<Solution_, ?, ?> getVariableMetaModel() {
        if (this.cachedMetamodel != null) {
            return this.cachedMetamodel;
        }
        this.cachedMetamodel = this.entityDescriptor.getEntityMetaModel().variable(this.variableName);
        return this.cachedMetamodel;
    }
}

