/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.inverserelation;

import ai.timefold.solver.core.impl.domain.variable.BasicVariableChangeEvent;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.listener.SourcedBasicVariableListener;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;

public class ExternalizedSingletonInverseVariableSupply<Solution_>
implements SourcedBasicVariableListener<Solution_, Object>,
SingletonInverseVariableSupply {
    protected final VariableDescriptor<Solution_> sourceVariableDescriptor;
    protected Map<Object, Object> inverseEntityMap = null;

    public ExternalizedSingletonInverseVariableSupply(VariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.sourceVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(@NonNull InnerScoreDirector<Solution_, ?> scoreDirector) {
        this.inverseEntityMap = new IdentityHashMap<Object, Object>();
        this.sourceVariableDescriptor.getEntityDescriptor().visitAllEntities(scoreDirector.getWorkingSolution(), this::insert);
    }

    @Override
    public void close() {
        this.inverseEntityMap = null;
    }

    @Override
    public void beforeChange(InnerScoreDirector<Solution_, ?> scoreDirector, BasicVariableChangeEvent<Object> event) {
        this.retract(event.entity());
    }

    @Override
    public void afterChange(InnerScoreDirector<Solution_, ?> scoreDirector, BasicVariableChangeEvent<Object> event) {
        this.insert(event.entity());
    }

    protected void insert(Object entity) {
        Object value = this.sourceVariableDescriptor.getValue(entity);
        if (value == null) {
            return;
        }
        Object oldInverseEntity = this.inverseEntityMap.put(value, entity);
        if (oldInverseEntity != null) {
            throw new IllegalStateException("The supply (" + String.valueOf(this) + ") is corrupted, because the entity (" + String.valueOf(entity) + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be inserted: another entity (" + String.valueOf(oldInverseEntity) + ") already has that value (" + String.valueOf(value) + ").");
        }
    }

    protected void retract(Object entity) {
        Object value = this.sourceVariableDescriptor.getValue(entity);
        if (value == null) {
            return;
        }
        Object oldInverseEntity = this.inverseEntityMap.remove(value);
        if (oldInverseEntity != entity) {
            throw new IllegalStateException("The supply (" + String.valueOf(this) + ") is corrupted, because the entity (" + String.valueOf(entity) + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be retracted: the entity was never inserted for that value (" + String.valueOf(value) + ").");
        }
    }

    @Override
    public Object getInverseSingleton(Object value) {
        return this.inverseEntityMap.get(value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceVariableDescriptor.getVariableName() + ")";
    }
}

