/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.exhaustivesearch.node;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.preview.api.move.Move;

public class ExhaustiveSearchNode {
    private final ExhaustiveSearchLayer layer;
    private final ExhaustiveSearchNode parent;
    private final long breadth;
    private Move move;
    private Move undoMove;
    private InnerScore<?> score;
    private InnerScore<?> optimisticBound;
    private boolean expandable = false;

    public ExhaustiveSearchNode(ExhaustiveSearchLayer layer, ExhaustiveSearchNode parent) {
        this.layer = layer;
        this.parent = parent;
        this.breadth = layer.assignBreadth();
    }

    public ExhaustiveSearchLayer getLayer() {
        return this.layer;
    }

    public ExhaustiveSearchNode getParent() {
        return this.parent;
    }

    public long getBreadth() {
        return this.breadth;
    }

    public Move getMove() {
        return this.move;
    }

    public void setMove(Move move) {
        this.move = move;
    }

    public Move getUndoMove() {
        return this.undoMove;
    }

    public void setUndoMove(Move undoMove) {
        this.undoMove = undoMove;
    }

    public <Score_ extends Score<Score_>> InnerScore<Score_> getScore() {
        return this.score;
    }

    public <Score_ extends Score<Score_>> void setInitializedScore(Score_ score) {
        this.setScore(InnerScore.fullyAssigned(score));
    }

    public void setScore(InnerScore<?> score) {
        this.score = score;
    }

    public <Score_ extends Score<Score_>> InnerScore<Score_> getOptimisticBound() {
        return this.optimisticBound;
    }

    public void setOptimisticBound(InnerScore<?> optimisticBound) {
        this.optimisticBound = optimisticBound;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public int getDepth() {
        return this.layer.getDepth();
    }

    public String getTreeId() {
        return this.layer.getDepth() + "-" + this.breadth;
    }

    public Object getEntity() {
        return this.layer.getEntity();
    }

    public boolean isLastLayer() {
        return this.layer.isLastLayer();
    }

    public long getParentBreadth() {
        return this.parent == null ? -1L : this.parent.getBreadth();
    }

    public String toString() {
        return this.getTreeId() + " (" + String.valueOf(this.layer.getEntity()) + ")";
    }
}

