/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity.decorator;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.AbstractCachingEntitySelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Objects;

public final class SortingEntitySelector<Solution_>
extends AbstractCachingEntitySelector<Solution_> {
    private final SelectionSorter<Solution_, Object> sorter;

    public SortingEntitySelector(EntitySelector<Solution_> childEntitySelector, SelectionCacheType cacheType, SelectionSorter<Solution_, Object> sorter) {
        super(childEntitySelector, cacheType);
        this.sorter = sorter;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        super.constructCache(solverScope);
        this.sorter.sort(solverScope.getScoreDirector(), this.cachedEntityList);
        this.logger.trace("    Sorted cachedEntityList: size ({}), entitySelector ({}).", (Object)this.cachedEntityList.size(), (Object)this);
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.cachedEntityList.iterator();
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.cachedEntityList.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.cachedEntityList.listIterator(index);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SortingEntitySelector that = (SortingEntitySelector)o;
        return Objects.equals(this.sorter, that.sorter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sorter);
    }

    public String toString() {
        return "Sorting(" + String.valueOf(this.childEntitySelector) + ")";
    }
}

