/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.list;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.ElementPositionRandomIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListChangeMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.FilteringValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ElementDestinationSelector<Solution_>
extends AbstractSelector<Solution_>
implements DestinationSelector<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final EntitySelector<Solution_> entitySelector;
    private final IterableValueSelector<Solution_> valueSelector;
    private final boolean randomSelection;
    private ListVariableStateSupply<Solution_, Object, Object> listVariableStateSupply;

    public ElementDestinationSelector(EntitySelector<Solution_> entitySelector, IterableValueSelector<Solution_> valueSelector, boolean randomSelection) {
        this.listVariableDescriptor = (ListVariableDescriptor)valueSelector.getVariableDescriptor();
        this.entitySelector = entitySelector;
        IterableValueSelector<Solution_> selector = ListChangeMoveSelector.filterPinnedListPlanningVariableValuesWithIndex(valueSelector, this::getListVariableStateSupply);
        this.valueSelector = this.listVariableDescriptor.allowsUnassignedValues() ? this.filterUnassignedValues(selector) : selector;
        this.randomSelection = randomSelection;
        this.phaseLifecycleSupport.addEventListener(this.entitySelector);
        this.phaseLifecycleSupport.addEventListener(this.valueSelector);
    }

    private ListVariableStateSupply<Solution_, Object, Object> getListVariableStateSupply() {
        return Objects.requireNonNull(this.listVariableStateSupply, "Impossible state: The listVariableStateSupply is not initialized yet.");
    }

    private IterableValueSelector<Solution_> filterUnassignedValues(IterableValueSelector<Solution_> valueSelector) {
        return FilteringValueSelector.ofAssigned(valueSelector, this::getListVariableStateSupply);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.listVariableStateSupply = (ListVariableStateSupply)supplyManager.demand(this.listVariableDescriptor.getStateDemand());
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.listVariableStateSupply = null;
    }

    @Override
    public long getSize() {
        if (this.entitySelector.getSize() == 0L) {
            return 0L;
        }
        return this.entitySelector.getSize() + this.valueSelector.getSize();
    }

    @Override
    public Iterator<ElementPosition> iterator() {
        if (this.randomSelection) {
            boolean allowsUnassignedValues = this.listVariableDescriptor.allowsUnassignedValues();
            long totalValueSize = this.valueSelector.getSize() - (long)(allowsUnassignedValues ? this.listVariableStateSupply.getUnassignedCount() : 0);
            long totalSize = Math.addExact(this.entitySelector.getSize(), totalValueSize);
            return new ElementPositionRandomIterator<Solution_>(this.listVariableStateSupply, this.entitySelector, this.valueSelector, this.workingRandom, totalSize, allowsUnassignedValues);
        }
        if (this.entitySelector.getSize() == 0L) {
            return Collections.emptyIterator();
        }
        Stream<ElementPosition> stream = StreamSupport.stream(this.entitySelector.spliterator(), false).map(entity -> ElementPosition.of(entity, this.listVariableDescriptor.getFirstUnpinnedIndex(entity)));
        stream = Stream.concat(stream, StreamSupport.stream(this.valueSelector.spliterator(), false).map(v -> this.listVariableStateSupply.getElementPosition(v).ensureAssigned()).map(positionInList -> ElementPosition.of(positionInList.entity(), positionInList.index() + 1)));
        if (this.listVariableDescriptor.allowsUnassignedValues()) {
            stream = Stream.concat(stream, Stream.of(ElementPosition.unassigned()));
        }
        return stream.iterator();
    }

    @Override
    public boolean isCountable() {
        return this.entitySelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.entitySelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    public ListVariableDescriptor<Solution_> getVariableDescriptor() {
        return (ListVariableDescriptor)this.valueSelector.getVariableDescriptor();
    }

    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.entitySelector.getEntityDescriptor();
    }

    public Iterator<Object> endingIterator() {
        return Stream.concat(StreamSupport.stream(Spliterators.spliterator(this.entitySelector.endingIterator(), this.entitySelector.getSize(), 0), false), StreamSupport.stream(Spliterators.spliterator(this.valueSelector.endingIterator(null), this.valueSelector.getSize(), 0), false)).iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ElementDestinationSelector)) return false;
        ElementDestinationSelector that = (ElementDestinationSelector)o;
        if (this.randomSelection != that.randomSelection) return false;
        if (!Objects.equals(this.entitySelector, that.entitySelector)) return false;
        if (!Objects.equals(this.valueSelector, that.valueSelector)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.entitySelector, this.valueSelector, this.randomSelection);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.entitySelector) + ", " + String.valueOf(this.valueSelector) + ")";
    }
}

