/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.list;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.solver.random.RandomUtils;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.Iterator;
import java.util.Random;

final class ElementPositionRandomIterator<Solution_>
implements Iterator<ElementPosition> {
    private final ListVariableStateSupply<Solution_, Object, Object> listVariableStateSupply;
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final EntitySelector<Solution_> entitySelector;
    private final IterableValueSelector<Solution_> valueSelector;
    private final Iterator<Object> entityIterator;
    private final Random workingRandom;
    private final long totalSize;
    private final boolean allowsUnassignedValues;
    private Iterator<Object> valueIterator;

    public ElementPositionRandomIterator(ListVariableStateSupply<Solution_, Object, Object> listVariableStateSupply, EntitySelector<Solution_> entitySelector, IterableValueSelector<Solution_> valueSelector, Random workingRandom, long totalSize, boolean allowsUnassignedValues) {
        this.listVariableStateSupply = listVariableStateSupply;
        this.listVariableDescriptor = listVariableStateSupply.getSourceVariableDescriptor();
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.entityIterator = entitySelector.iterator();
        this.workingRandom = workingRandom;
        this.totalSize = totalSize;
        if (totalSize < 1L) {
            throw new IllegalStateException("Impossible state: totalSize (%d) < 1".formatted(totalSize));
        }
        this.allowsUnassignedValues = allowsUnassignedValues;
        this.valueIterator = null;
    }

    @Override
    public boolean hasNext() {
        return this.entityIterator.hasNext();
    }

    @Override
    public ElementPosition next() {
        Object value;
        long entitySize = this.entitySelector.getSize();
        long entityBoundary = this.allowsUnassignedValues ? entitySize + 1L : entitySize;
        long random = RandomUtils.nextLong(this.workingRandom, this.allowsUnassignedValues ? this.totalSize + 1L : this.totalSize);
        if (this.allowsUnassignedValues && random == 0L) {
            return ElementPosition.unassigned();
        }
        if (random < entityBoundary) {
            Object entity = this.entityIterator.next();
            return ElementPosition.of(entity, this.listVariableDescriptor.getFirstUnpinnedIndex(entity));
        }
        if (this.valueIterator == null) {
            this.valueIterator = this.valueSelector.iterator();
        }
        Object object = value = this.valueIterator.hasNext() ? this.valueIterator.next() : null;
        if (value == null) {
            Object entity = this.entityIterator.next();
            int unpinnedSize = this.listVariableDescriptor.getUnpinnedSubListSize(entity);
            if (unpinnedSize == 0) {
                return ElementPosition.of(entity, this.listVariableDescriptor.getListSize(entity));
            }
            int randomIndex = this.workingRandom.nextInt(unpinnedSize + 1);
            return ElementPosition.of(entity, this.listVariableDescriptor.getFirstUnpinnedIndex(entity) + randomIndex);
        }
        ElementPosition elementPosition = this.listVariableStateSupply.getElementPosition(value);
        if (elementPosition instanceof PositionInList) {
            PositionInList positionInList = (PositionInList)elementPosition;
            return ElementPosition.of(positionInList.entity(), positionInList.index() + 1);
        }
        return ElementPosition.unassigned();
    }
}

