/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.composite;

import ai.timefold.solver.core.impl.heuristic.move.CompositeMove;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.move.NoChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.CompositeMoveSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CartesianProductMoveSelector<Solution_>
extends CompositeMoveSelector<Solution_> {
    private static final Move<?> EMPTY_MARK = NoChangeMove.getInstance();
    private final boolean ignoreEmptyChildIterators;

    public CartesianProductMoveSelector(List<MoveSelector<Solution_>> childMoveSelectorList, boolean ignoreEmptyChildIterators, boolean randomSelection) {
        super(childMoveSelectorList, randomSelection);
        this.ignoreEmptyChildIterators = ignoreEmptyChildIterators;
    }

    @Override
    public boolean isNeverEnding() {
        if (this.randomSelection) {
            return true;
        }
        return !this.childMoveSelectorList.isEmpty() && ((MoveSelector)this.childMoveSelectorList.get(this.childMoveSelectorList.size() - 1)).isNeverEnding();
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (MoveSelector moveSelector : this.childMoveSelectorList) {
            long childSize = moveSelector.getSize();
            if (childSize == 0L) {
                if (this.ignoreEmptyChildIterators) continue;
                return 0L;
            }
            if (size == 0L) {
                size = childSize;
                continue;
            }
            size *= childSize;
        }
        return size;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (!this.randomSelection) {
            return new OriginalCartesianProductMoveIterator();
        }
        return new RandomCartesianProductMoveIterator();
    }

    @Override
    public String toString() {
        return "CartesianProduct(" + String.valueOf(this.childMoveSelectorList) + ")";
    }

    public class OriginalCartesianProductMoveIterator
    extends UpcomingSelectionIterator<Move<Solution_>> {
        private List<Iterator<Move<Solution_>>> moveIteratorList;
        private Move<Solution_>[] subSelections;

        public OriginalCartesianProductMoveIterator() {
            this.moveIteratorList = new ArrayList(CartesianProductMoveSelector.this.childMoveSelectorList.size());
            for (int i = 0; i < CartesianProductMoveSelector.this.childMoveSelectorList.size(); ++i) {
                this.moveIteratorList.add(null);
            }
            this.subSelections = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected Move<Solution_> createUpcomingSelection() {
            int childSize = this.moveIteratorList.size();
            Move[] moveList = new Move[childSize];
            if (this.subSelections == null) {
                startingIndex = -1;
            } else {
                Iterator moveIterator;
                for (startingIndex = childSize - 1; startingIndex >= 0 && !(moveIterator = this.moveIteratorList.get(startingIndex)).hasNext(); --startingIndex) {
                }
                if (startingIndex < 0) {
                    return (Move)this.noUpcomingSelection();
                }
                System.arraycopy(this.subSelections, 0, moveList, 0, startingIndex);
                moveList[startingIndex] = this.moveIteratorList.get(startingIndex).next();
            }
            for (int i = startingIndex + 1; i < childSize; ++i) {
                Move<?> next;
                Iterator moveIterator = ((MoveSelector)CartesianProductMoveSelector.this.childMoveSelectorList.get(i)).iterator();
                this.moveIteratorList.set(i, moveIterator);
                if (!moveIterator.hasNext()) {
                    if (!CartesianProductMoveSelector.this.ignoreEmptyChildIterators) return (Move)this.noUpcomingSelection();
                    next = EMPTY_MARK;
                } else {
                    next = (Move<?>)moveIterator.next();
                }
                moveList[i] = next;
            }
            this.subSelections = moveList;
            if (!CartesianProductMoveSelector.this.ignoreEmptyChildIterators) return CompositeMove.buildMove((Move[])moveList);
            Move[] newMoveList = new Move[childSize];
            int newSize = 0;
            for (int i = 0; i < childSize; ++i) {
                if (moveList[i] == EMPTY_MARK) continue;
                newMoveList[newSize] = moveList[i];
                ++newSize;
            }
            if (newSize == 0) {
                return (Move)this.noUpcomingSelection();
            }
            if (newSize == 1) {
                return newMoveList[0];
            }
            moveList = Arrays.copyOfRange(newMoveList, 0, newSize);
            return CompositeMove.buildMove((Move[])moveList);
        }
    }

    public class RandomCartesianProductMoveIterator
    extends SelectionIterator<Move<Solution_>> {
        private List<Iterator<Move<Solution_>>> moveIteratorList;
        private Boolean empty;

        public RandomCartesianProductMoveIterator() {
            this.moveIteratorList = new ArrayList(CartesianProductMoveSelector.this.childMoveSelectorList.size());
            this.empty = null;
            for (MoveSelector moveSelector : CartesianProductMoveSelector.this.childMoveSelectorList) {
                this.moveIteratorList.add(moveSelector.iterator());
            }
        }

        @Override
        public boolean hasNext() {
            if (this.empty == null) {
                int emptyCount = 0;
                for (Iterator moveIterator : this.moveIteratorList) {
                    if (moveIterator.hasNext()) continue;
                    ++emptyCount;
                    if (CartesianProductMoveSelector.this.ignoreEmptyChildIterators) continue;
                    break;
                }
                this.empty = CartesianProductMoveSelector.this.ignoreEmptyChildIterators ? emptyCount == this.moveIteratorList.size() : emptyCount > 0;
            }
            return this.empty == false;
        }

        @Override
        public Move<Solution_> next() {
            ArrayList moveList = new ArrayList(this.moveIteratorList.size());
            for (int i = 0; i < this.moveIteratorList.size(); ++i) {
                Iterator<Move<Object>> moveIterator = this.moveIteratorList.get(i);
                boolean skip = false;
                if (!moveIterator.hasNext()) {
                    MoveSelector moveSelector = (MoveSelector)CartesianProductMoveSelector.this.childMoveSelectorList.get(i);
                    moveIterator = moveSelector.iterator();
                    this.moveIteratorList.set(i, moveIterator);
                    if (!moveIterator.hasNext()) {
                        if (CartesianProductMoveSelector.this.ignoreEmptyChildIterators) {
                            skip = true;
                        } else {
                            throw new NoSuchElementException("The iterator of childMoveSelector (" + String.valueOf(moveSelector) + ") is empty.");
                        }
                    }
                }
                if (skip) continue;
                moveList.add(moveIterator.next());
            }
            if (CartesianProductMoveSelector.this.ignoreEmptyChildIterators) {
                if (moveList.isEmpty()) {
                    throw new NoSuchElementException("All iterators of childMoveSelectorList (" + String.valueOf(CartesianProductMoveSelector.this.childMoveSelectorList) + ") are empty.");
                }
                if (moveList.size() == 1) {
                    return (Move)moveList.get(0);
                }
            }
            return CompositeMove.buildMove((Move[])moveList.toArray(new Move[0]));
        }
    }
}

