/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.decorator;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCachingMoveSelector<Solution_>
extends AbstractMoveSelector<Solution_>
implements SelectionCacheLifecycleListener<Solution_> {
    protected final MoveSelector<Solution_> childMoveSelector;
    protected final SelectionCacheType cacheType;
    protected List<Move<Solution_>> cachedMoveList = null;

    public AbstractCachingMoveSelector(MoveSelector<Solution_> childMoveSelector, SelectionCacheType cacheType) {
        this.childMoveSelector = childMoveSelector;
        this.cacheType = cacheType;
        if (childMoveSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + String.valueOf(this) + ") has a childMoveSelector (" + String.valueOf(childMoveSelector) + ") with neverEnding (" + childMoveSelector.isNeverEnding() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childMoveSelector);
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + String.valueOf(this) + ") does not support the cacheType (" + String.valueOf((Object)cacheType) + ").");
        }
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    public MoveSelector<Solution_> getChildMoveSelector() {
        return this.childMoveSelector;
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        long childSize = this.childMoveSelector.getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + String.valueOf(this) + ") has a childMoveSelector (" + String.valueOf(this.childMoveSelector) + ") with childSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.cachedMoveList = new ArrayList<Move<Solution_>>((int)childSize);
        this.childMoveSelector.iterator().forEachRemaining(this.cachedMoveList::add);
        this.logger.trace("    Created cachedMoveList: size ({}), moveSelector ({}).", (Object)this.cachedMoveList.size(), (Object)this);
    }

    @Override
    public void disposeCache(SolverScope<Solution_> solverScope) {
        this.cachedMoveList = null;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public long getSize() {
        return this.cachedMoveList.size();
    }
}

