/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.PillarChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PillarChangeMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    protected final PillarSelector<Solution_> pillarSelector;
    protected final ValueSelector<Solution_> valueSelector;
    protected final boolean randomSelection;

    public PillarChangeMoveSelector(PillarSelector<Solution_> pillarSelector, ValueSelector<Solution_> valueSelector, boolean randomSelection) {
        BasicVariableDescriptor basicVariableDescriptor;
        boolean isChained;
        this.pillarSelector = pillarSelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        GenuineVariableDescriptor<Solution_> variableDescriptor = valueSelector.getVariableDescriptor();
        boolean bl = isChained = variableDescriptor instanceof BasicVariableDescriptor && (basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor).isChained();
        if (isChained) {
            throw new IllegalStateException("The selector (%s) has a variableDescriptor (%s) which is chained (%s).".formatted(this, variableDescriptor, isChained));
        }
        this.phaseLifecycleSupport.addEventListener(pillarSelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public boolean isCountable() {
        return this.pillarSelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.pillarSelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.pillarSelector.getSize() * ((IterableValueSelector)this.valueSelector).getSize();
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (!this.randomSelection) {
            return new OriginalPillarChangeMoveIterator();
        }
        return new RandomPillarChangeMoveIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.pillarSelector) + ", " + String.valueOf(this.valueSelector) + ")";
    }

    private class OriginalPillarChangeMoveIterator
    extends UpcomingSelectionIterator<Move<Solution_>> {
        private Iterator<List<Object>> pillarIterator;
        private Iterator<Object> valueIterator;
        private List<Object> upcomingPillar;

        private OriginalPillarChangeMoveIterator() {
            this.pillarIterator = PillarChangeMoveSelector.this.pillarSelector.iterator();
            this.valueIterator = Collections.emptyIterator();
        }

        @Override
        protected Move<Solution_> createUpcomingSelection() {
            if (!this.valueIterator.hasNext()) {
                if (!this.pillarIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
                this.upcomingPillar = this.pillarIterator.next();
                this.valueIterator = PillarChangeMoveSelector.this.valueSelector.iterator(this.upcomingPillar.get(0));
                if (!this.valueIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
            }
            Object toValue = this.valueIterator.next();
            return new PillarChangeMove(this.upcomingPillar, PillarChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
        }
    }

    private class RandomPillarChangeMoveIterator
    extends UpcomingSelectionIterator<Move<Solution_>> {
        private Iterator<List<Object>> pillarIterator;
        private Iterator<Object> valueIterator;

        private RandomPillarChangeMoveIterator() {
            this.pillarIterator = PillarChangeMoveSelector.this.pillarSelector.iterator();
            this.valueIterator = Collections.emptyIterator();
        }

        @Override
        protected Move<Solution_> createUpcomingSelection() {
            if (!this.pillarIterator.hasNext()) {
                this.pillarIterator = PillarChangeMoveSelector.this.pillarSelector.iterator();
                if (!this.pillarIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
            }
            List<Object> pillar = this.pillarIterator.next();
            if (!this.valueIterator.hasNext()) {
                this.valueIterator = PillarChangeMoveSelector.this.valueSelector.iterator(pillar.get(0));
                if (!this.valueIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
            }
            Object toValue = this.valueIterator.next();
            return new PillarChangeMove(pillar, PillarChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
        }
    }
}

