/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.Collections;
import java.util.List;

record KOptAffectedElements(int wrappedStartIndex, int wrappedEndIndex, List<Range> affectedMiddleRangeList) {
    static KOptAffectedElements forMiddleRange(int startInclusive, int endExclusive) {
        return new KOptAffectedElements(-1, -1, List.of(new Range(startInclusive, endExclusive)));
    }

    static KOptAffectedElements forWrappedRange(int startInclusive, int endExclusive) {
        return new KOptAffectedElements(startInclusive, endExclusive, Collections.emptyList());
    }

    public KOptAffectedElements merge(KOptAffectedElements other) {
        boolean removedAny;
        int newWrappedStartIndex = this.wrappedStartIndex;
        int newWrappedEndIndex = this.wrappedEndIndex;
        if (other.wrappedStartIndex != -1) {
            if (newWrappedStartIndex != -1) {
                newWrappedStartIndex = Math.min(other.wrappedStartIndex, newWrappedStartIndex);
                newWrappedEndIndex = Math.max(other.wrappedEndIndex, newWrappedEndIndex);
            } else {
                newWrappedStartIndex = other.wrappedStartIndex;
                newWrappedEndIndex = other.wrappedEndIndex;
            }
        }
        List<Range> newAffectedMiddleRangeList = CollectionUtils.concat(this.affectedMiddleRangeList, other.affectedMiddleRangeList);
        block0: do {
            removedAny = false;
            int listSize = newAffectedMiddleRangeList.size();
            for (int i = 0; i < listSize; ++i) {
                for (int j = i + 1; j < listSize; ++j) {
                    Range leftRange = newAffectedMiddleRangeList.get(i);
                    Range rightRange = newAffectedMiddleRangeList.get(j);
                    if (leftRange.startInclusive() > rightRange.endExclusive() || rightRange.startInclusive() > leftRange.endExclusive()) continue;
                    Range mergedRange = new Range(Math.min(leftRange.startInclusive(), rightRange.startInclusive()), Math.max(leftRange.endExclusive(), rightRange.endExclusive()));
                    newAffectedMiddleRangeList.set(i, mergedRange);
                    newAffectedMiddleRangeList.remove(j);
                    removedAny = true;
                    continue block0;
                }
            }
        } while (removedAny);
        return new KOptAffectedElements(newWrappedStartIndex, newWrappedEndIndex, newAffectedMiddleRangeList);
    }

    public record Range(int startInclusive, int endExclusive) {
    }
}

