/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.FlipSublistAction;
import ai.timefold.solver.core.impl.score.director.ValueRangeManager;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class TwoOptListMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object firstEntity;
    private final Object secondEntity;
    private final int firstEdgeEndpoint;
    private final int secondEdgeEndpoint;
    private final int shift;
    private final int entityFirstUnpinnedIndex;

    public TwoOptListMove(ListVariableDescriptor<Solution_> variableDescriptor, Object firstEntity, Object secondEntity, int firstEdgeEndpoint, int secondEdgeEndpoint) {
        this.variableDescriptor = variableDescriptor;
        this.firstEntity = firstEntity;
        this.secondEntity = secondEntity;
        this.firstEdgeEndpoint = firstEdgeEndpoint;
        this.secondEdgeEndpoint = secondEdgeEndpoint;
        if (firstEntity == secondEntity) {
            this.entityFirstUnpinnedIndex = variableDescriptor.getFirstUnpinnedIndex(firstEntity);
            if (firstEdgeEndpoint == 0) {
                this.shift = -secondEdgeEndpoint;
            } else if (secondEdgeEndpoint < firstEdgeEndpoint) {
                int listSize = variableDescriptor.getListSize(firstEntity);
                int flippedSectionSize = listSize - firstEdgeEndpoint + secondEdgeEndpoint;
                int firstElementIndexInFlipped = listSize - firstEdgeEndpoint;
                int firstElementMirroredIndex = flippedSectionSize - firstElementIndexInFlipped;
                this.shift = -(firstEdgeEndpoint + firstElementMirroredIndex - 1);
            } else {
                this.shift = 0;
            }
        } else {
            this.entityFirstUnpinnedIndex = 0;
            this.shift = 0;
        }
    }

    private TwoOptListMove(ListVariableDescriptor<Solution_> variableDescriptor, Object firstEntity, Object secondEntity, int firstEdgeEndpoint, int secondEdgeEndpoint, int entityFirstUnpinnedIndex, int shift) {
        this.variableDescriptor = variableDescriptor;
        this.firstEntity = firstEntity;
        this.secondEntity = secondEntity;
        this.firstEdgeEndpoint = firstEdgeEndpoint;
        this.secondEdgeEndpoint = secondEdgeEndpoint;
        this.entityFirstUnpinnedIndex = entityFirstUnpinnedIndex;
        this.shift = shift;
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        if (this.firstEntity == this.secondEntity) {
            this.doSublistReversal(scoreDirector);
        } else {
            this.doTailSwap(scoreDirector);
        }
    }

    private void doTailSwap(ScoreDirector<Solution_> scoreDirector) {
        VariableDescriptorAwareScoreDirector castScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        Object firstListVariable = this.variableDescriptor.getValue(this.firstEntity);
        Object secondListVariable = this.variableDescriptor.getValue(this.secondEntity);
        int firstOriginalSize = firstListVariable.size();
        int secondOriginalSize = secondListVariable.size();
        castScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, firstOriginalSize);
        castScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.secondEntity, this.secondEdgeEndpoint, secondOriginalSize);
        List firstListVariableTail = firstListVariable.subList(this.firstEdgeEndpoint, firstOriginalSize);
        List secondListVariableTail = secondListVariable.subList(this.secondEdgeEndpoint, secondOriginalSize);
        int tailSizeDifference = secondListVariableTail.size() - firstListVariableTail.size();
        ArrayList firstListVariableTailCopy = new ArrayList(firstListVariableTail);
        firstListVariableTail.clear();
        firstListVariable.addAll(secondListVariableTail);
        secondListVariableTail.clear();
        secondListVariable.addAll(firstListVariableTailCopy);
        castScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, firstOriginalSize + tailSizeDifference);
        castScoreDirector.afterListVariableChanged(this.variableDescriptor, this.secondEntity, this.secondEdgeEndpoint, secondOriginalSize - tailSizeDifference);
    }

    private void doSublistReversal(ScoreDirector<Solution_> scoreDirector) {
        VariableDescriptorAwareScoreDirector castScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        Object listVariable = this.variableDescriptor.getValue(this.firstEntity);
        if (this.firstEdgeEndpoint < this.secondEdgeEndpoint) {
            if (this.firstEdgeEndpoint > 0) {
                castScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            } else {
                castScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, this.entityFirstUnpinnedIndex, listVariable.size());
            }
            if (this.firstEdgeEndpoint == 0 && this.shift > 0) {
                if (this.entityFirstUnpinnedIndex == 0) {
                    Collections.rotate(listVariable, this.shift);
                } else {
                    Collections.rotate(listVariable.subList(this.entityFirstUnpinnedIndex, listVariable.size()), this.shift);
                }
            }
            FlipSublistAction.flipSublist(listVariable, this.entityFirstUnpinnedIndex, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            if (this.firstEdgeEndpoint == 0 && this.shift < 0) {
                if (this.entityFirstUnpinnedIndex == 0) {
                    Collections.rotate(listVariable, this.shift);
                } else {
                    Collections.rotate(listVariable.subList(this.entityFirstUnpinnedIndex, listVariable.size()), this.shift);
                }
            }
            if (this.firstEdgeEndpoint > 0) {
                castScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            } else {
                castScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, this.entityFirstUnpinnedIndex, listVariable.size());
            }
        } else {
            castScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, this.entityFirstUnpinnedIndex, listVariable.size());
            if (this.shift > 0) {
                if (this.entityFirstUnpinnedIndex == 0) {
                    Collections.rotate(listVariable, this.shift);
                } else {
                    Collections.rotate(listVariable.subList(this.entityFirstUnpinnedIndex, listVariable.size()), this.shift);
                }
            }
            FlipSublistAction.flipSublist(listVariable, this.entityFirstUnpinnedIndex, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            if (this.shift < 0) {
                if (this.entityFirstUnpinnedIndex == 0) {
                    Collections.rotate(listVariable, this.shift);
                } else {
                    Collections.rotate(listVariable.subList(this.entityFirstUnpinnedIndex, listVariable.size()), this.shift);
                }
            }
            castScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, this.entityFirstUnpinnedIndex, listVariable.size());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        boolean sameEntity;
        boolean bl = sameEntity = this.firstEntity == this.secondEntity;
        if (sameEntity && this.shift == 0) {
            if (Math.abs(this.secondEdgeEndpoint - this.firstEdgeEndpoint) < 2) return false;
        }
        boolean bl2 = true;
        boolean doable = bl2;
        if (!doable) return doable;
        if (sameEntity) return doable;
        if (this.variableDescriptor.canExtractValueRangeFromSolution()) {
            return doable;
        }
        ValueRangeManager valueRangeManager = ((VariableDescriptorAwareScoreDirector)scoreDirector).getValueRangeManager();
        CountableValueRange firstValueRange = valueRangeManager.getFromEntity(this.variableDescriptor.getValueRangeDescriptor(), this.firstEntity);
        Object firstListVariable = this.variableDescriptor.getValue(this.firstEntity);
        List firstListVariableTail = firstListVariable.subList(this.firstEdgeEndpoint, firstListVariable.size());
        CountableValueRange secondValueRange = valueRangeManager.getFromEntity(this.variableDescriptor.getValueRangeDescriptor(), this.secondEntity);
        Object secondListVariable = this.variableDescriptor.getValue(this.secondEntity);
        List secondListVariableTail = secondListVariable.subList(this.secondEdgeEndpoint, secondListVariable.size());
        if (!firstListVariableTail.stream().allMatch(secondValueRange::contains)) return false;
        if (!secondListVariableTail.stream().allMatch(firstValueRange::contains)) return false;
        return true;
    }

    @Override
    public TwoOptListMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new TwoOptListMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.firstEntity), destinationScoreDirector.lookUpWorkingObject(this.secondEntity), this.firstEdgeEndpoint, this.secondEdgeEndpoint, this.entityFirstUnpinnedIndex, this.shift);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return "2-Opt(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<?> getPlanningEntities() {
        if (this.firstEntity == this.secondEntity) {
            return Collections.singleton(this.firstEntity);
        }
        return Set.of(this.firstEntity, this.secondEntity);
    }

    @Override
    public Collection<?> getPlanningValues() {
        if (this.firstEntity == this.secondEntity) {
            Object listVariable = this.variableDescriptor.getValue(this.firstEntity);
            if (this.firstEdgeEndpoint < this.secondEdgeEndpoint) {
                return new ArrayList(listVariable.subList(this.firstEdgeEndpoint, this.secondEdgeEndpoint));
            }
            List firstHalfReversedPath = listVariable.subList(this.firstEdgeEndpoint, listVariable.size());
            List secondHalfReversedPath = listVariable.subList(this.entityFirstUnpinnedIndex, this.secondEdgeEndpoint);
            return CollectionUtils.concat(firstHalfReversedPath, secondHalfReversedPath);
        }
        Object firstListVariable = this.variableDescriptor.getValue(this.firstEntity);
        Object secondListVariable = this.variableDescriptor.getValue(this.secondEntity);
        List firstListVariableTail = firstListVariable.subList(this.firstEdgeEndpoint, firstListVariable.size());
        List secondListVariableTail = secondListVariable.subList(this.secondEdgeEndpoint, secondListVariable.size());
        ArrayList out = new ArrayList(firstListVariableTail.size() + secondListVariableTail.size());
        out.addAll(firstListVariableTail);
        out.addAll(secondListVariableTail);
        return out;
    }

    public Object getFirstEntity() {
        return this.firstEntity;
    }

    public Object getSecondEntity() {
        return this.secondEntity;
    }

    public Object getFirstEdgeEndpoint() {
        return this.firstEdgeEndpoint;
    }

    public Object getSecondEdgeEndpoint() {
        return this.secondEdgeEndpoint;
    }

    public String toString() {
        return "2-Opt(firstEntity=" + String.valueOf(this.firstEntity) + ", secondEntity=" + String.valueOf(this.secondEntity) + ", firstEndpointIndex=" + this.firstEdgeEndpoint + ", secondEndpointIndex=" + this.secondEdgeEndpoint + ")";
    }
}

