/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.decorator;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

abstract class AbstractInverseEntityFilteringValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements IterableValueSelector<Solution_> {
    protected final IterableValueSelector<Solution_> childValueSelector;
    protected ListVariableStateSupply<Solution_, Object, Object> listVariableStateSupply;

    protected AbstractInverseEntityFilteringValueSelector(IterableValueSelector<Solution_> childValueSelector) {
        if (childValueSelector.isNeverEnding()) {
            throw new IllegalArgumentException("The selector (" + String.valueOf(this) + ") has a childValueSelector (" + String.valueOf(childValueSelector) + ") with neverEnding (" + childValueSelector.isNeverEnding() + ").\nThis is not allowed because " + AbstractInverseEntityFilteringValueSelector.class.getSimpleName() + " cannot decorate a never-ending child value selector.\nThis could be a result of using random selection order (which is often the default).");
        }
        this.childValueSelector = childValueSelector;
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
    }

    protected abstract boolean valueFilter(Object var1);

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        ListVariableDescriptor variableDescriptor = (ListVariableDescriptor)this.childValueSelector.getVariableDescriptor();
        this.listVariableStateSupply = (ListVariableStateSupply)phaseScope.getScoreDirector().getSupplyManager().demand(variableDescriptor.getStateDemand());
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.listVariableStateSupply = null;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    @Override
    public long getSize() {
        return this.streamUnassignedValues().count();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.streamUnassignedValues().iterator();
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.iterator();
    }

    private Stream<Object> streamUnassignedValues() {
        return StreamSupport.stream(this.childValueSelector.spliterator(), false).filter(this::valueFilter);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractInverseEntityFilteringValueSelector that = (AbstractInverseEntityFilteringValueSelector)other;
        return Objects.equals(this.childValueSelector, that.childValueSelector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childValueSelector);
    }
}

