/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood;

import ai.timefold.solver.core.impl.neighborhood.MoveRepository;
import ai.timefold.solver.core.impl.neighborhood.move.InnerMoveStream;
import ai.timefold.solver.core.impl.neighborhood.move.MoveIterable;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultMoveStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultNeighborhoodSession;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.director.SessionContext;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class NeighborhoodsBasedMoveRepository<Solution_>
implements MoveRepository<Solution_> {
    private final DefaultMoveStreamFactory<Solution_> moveStreamFactory;
    private final InnerMoveStream<Solution_> moveStream;
    private final boolean random;
    private @Nullable DefaultNeighborhoodSession<Solution_> neighborhoodSession;
    private @Nullable MoveIterable<Solution_> moveIterable;
    private @Nullable Random workingRandom;

    public NeighborhoodsBasedMoveRepository(DefaultMoveStreamFactory<Solution_> moveStreamFactory, InnerMoveStream<Solution_> moveStream, boolean random) {
        this.moveStreamFactory = Objects.requireNonNull(moveStreamFactory);
        this.moveStream = Objects.requireNonNull(moveStream);
        this.random = random;
    }

    @Override
    public boolean isNeverEnding() {
        return this.random;
    }

    @Override
    public void initialize(SessionContext<Solution_> context) {
        if (this.neighborhoodSession != null) {
            throw new IllegalStateException("Impossible state: move repository initialized twice.");
        }
        this.neighborhoodSession = this.moveStreamFactory.createSession(context);
        this.moveStreamFactory.getSolutionDescriptor().visitAll(context.workingSolution(), this.neighborhoodSession::insert);
        this.neighborhoodSession.settle();
        this.moveIterable = this.moveStream.getMoveIterable(this.neighborhoodSession);
    }

    public void insert(Object planningEntityOrProblemFact) {
        Objects.requireNonNull(this.neighborhoodSession).insert(planningEntityOrProblemFact);
    }

    public void update(Object planningEntityOrProblemFact) {
        Objects.requireNonNull(this.neighborhoodSession).update(planningEntityOrProblemFact);
    }

    public void retract(Object planningEntityOrProblemFact) {
        Objects.requireNonNull(this.neighborhoodSession).retract(planningEntityOrProblemFact);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        this.workingRandom = phaseScope.getWorkingRandom();
        phaseScope.getScoreDirector().setMoveRepository(this);
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        Objects.requireNonNull(this.neighborhoodSession).settle();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        if (this.neighborhoodSession != null) {
            this.neighborhoodSession = null;
        }
        phaseScope.getScoreDirector().setMoveRepository(null);
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new NeverendingMoveIterator<Solution_>(this.moveIterable, this.random ? this.workingRandom : null);
    }

    @NullMarked
    private static final class NeverendingMoveIterator<Solution_>
    implements Iterator<Move<Solution_>> {
        private final MoveIterable<Solution_> iterable;
        private final @Nullable Random workingRandom;
        private Iterator<Move<Solution_>> iterator;

        public NeverendingMoveIterator(MoveIterable<Solution_> iterable, @Nullable Random workingRandom) {
            this.iterable = Objects.requireNonNull(iterable);
            this.workingRandom = workingRandom;
            this.iterator = this.createIterator();
        }

        private Iterator<Move<Solution_>> createIterator() {
            return this.workingRandom == null ? this.iterable.iterator() : this.iterable.iterator(this.workingRandom);
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            this.iterator = this.createIterator();
            return this.iterator.hasNext();
        }

        @Override
        public Move<Solution_> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }
    }
}

