/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni;

import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.UniEnumeratingFilter;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.EnumeratingStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.DataNodeBuildHelper;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.AbstractUniEnumeratingStream;
import java.util.Objects;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class FilterUniEnumeratingStream<Solution_, A>
extends AbstractUniEnumeratingStream<Solution_, A> {
    private final UniEnumeratingFilter<Solution_, A> filter;

    public FilterUniEnumeratingStream(EnumeratingStreamFactory<Solution_> enumeratingStreamFactory, AbstractUniEnumeratingStream<Solution_, A> parent, UniEnumeratingFilter<Solution_, A> filter) {
        super(enumeratingStreamFactory, parent);
        this.filter = Objects.requireNonNull(filter, "The filter cannot be null.");
    }

    @Override
    public void buildNode(DataNodeBuildHelper<Solution_> buildHelper) {
        Predicate predicate = this.filter.toPredicate(buildHelper.getSessionContext().solutionView());
        buildHelper.putInsertUpdateRetract(this, this.childStreamList, tupleLifecycle -> TupleLifecycle.conditionally(tupleLifecycle, predicate));
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.filter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FilterUniEnumeratingStream) {
            FilterUniEnumeratingStream other = (FilterUniEnumeratingStream)o;
            return this.parent == other.parent && this.filter == other.filter;
        }
        return false;
    }

    public String toString() {
        return "Filter() with " + this.childStreamList.size() + " children";
    }
}

