/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.constraint;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.api.score.stream.DefaultConstraintJustification;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;

public final class DefaultConstraintMatchTotal<Score_ extends Score<Score_>>
implements ConstraintMatchTotal<Score_>,
Comparable<DefaultConstraintMatchTotal<Score_>> {
    private final ConstraintRef constraintRef;
    private final Score_ constraintWeight;
    private final Set<ConstraintMatch<Score_>> constraintMatchSet = new LinkedHashSet<ConstraintMatch<Score_>>();
    private Score_ score;

    @Deprecated(forRemoval=true, since="1.4.0")
    public DefaultConstraintMatchTotal(String constraintPackage, String constraintName) {
        this(ConstraintRef.of(constraintPackage, constraintName));
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public DefaultConstraintMatchTotal(ConstraintRef constraintRef) {
        this.constraintRef = Objects.requireNonNull(constraintRef);
        this.constraintWeight = null;
    }

    @Deprecated(forRemoval=true, since="1.4.0")
    public DefaultConstraintMatchTotal(Constraint constraint, Score_ constraintWeight) {
        this(constraint.getConstraintRef(), constraintWeight);
    }

    @Deprecated(forRemoval=true, since="1.4.0")
    public DefaultConstraintMatchTotal(String constraintPackage, String constraintName, Score_ constraintWeight) {
        this(ConstraintRef.of(constraintPackage, constraintName), constraintWeight);
    }

    public DefaultConstraintMatchTotal(ConstraintRef constraintRef, Score_ constraintWeight) {
        this.constraintRef = Objects.requireNonNull(constraintRef);
        this.constraintWeight = (Score)Objects.requireNonNull(constraintWeight);
        this.score = constraintWeight.zero();
    }

    @Override
    public @NonNull ConstraintRef getConstraintRef() {
        return this.constraintRef;
    }

    @Override
    public @NonNull Score_ getConstraintWeight() {
        return this.constraintWeight;
    }

    @Override
    public @NonNull Set<ConstraintMatch<Score_>> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    @Override
    public @NonNull Score_ getScore() {
        return this.score;
    }

    public ConstraintMatch<Score_> addConstraintMatch(List<Object> justifications, Score_ score) {
        return this.addConstraintMatch(DefaultConstraintJustification.of(score, justifications), justifications, score);
    }

    public ConstraintMatch<Score_> addConstraintMatch(ConstraintJustification justification, Collection<Object> indictedObjects, Score_ score) {
        ConstraintMatch<Score_> constraintMatch = new ConstraintMatch<Score_>(this.constraintRef, justification, indictedObjects, score);
        this.addConstraintMatch(constraintMatch);
        return constraintMatch;
    }

    public void addConstraintMatch(ConstraintMatch<Score_> constraintMatch) {
        Score_ constraintMatchScore = constraintMatch.getScore();
        this.score = this.score == null ? constraintMatchScore : this.score.add(constraintMatchScore);
        this.constraintMatchSet.add(constraintMatch);
    }

    public void removeConstraintMatch(ConstraintMatch<Score_> constraintMatch) {
        this.score = this.score.subtract(constraintMatch.getScore());
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The constraintMatchTotal (" + String.valueOf(this) + ") could not remove constraintMatch (" + String.valueOf(constraintMatch) + ") from its constraintMatchSet (" + String.valueOf(this.constraintMatchSet) + ").");
        }
    }

    @Override
    public int compareTo(DefaultConstraintMatchTotal<Score_> other) {
        return this.constraintRef.compareTo(other.constraintRef);
    }

    public boolean equals(Object o) {
        if (o instanceof DefaultConstraintMatchTotal) {
            DefaultConstraintMatchTotal other = (DefaultConstraintMatchTotal)o;
            return this.constraintRef.equals(other.constraintRef);
        }
        return false;
    }

    public int hashCode() {
        return this.constraintRef.hashCode();
    }

    public String toString() {
        return String.valueOf(this.constraintRef) + "=" + String.valueOf(this.score);
    }
}

