/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.constraint;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NonNull;

public final class DefaultIndictment<Score_ extends Score<Score_>>
implements Indictment<Score_> {
    private final Object indictedObject;
    private final Set<ConstraintMatch<Score_>> constraintMatchSet = new LinkedHashSet<ConstraintMatch<Score_>>();
    private List<ConstraintJustification> constraintJustificationList;
    private Score_ score;

    public DefaultIndictment(Object indictedObject, Score_ zeroScore) {
        this.indictedObject = indictedObject;
        this.score = zeroScore;
    }

    @Override
    public <IndictedObject_> @NonNull IndictedObject_ getIndictedObject() {
        return (IndictedObject_)this.indictedObject;
    }

    @Override
    public @NonNull Set<ConstraintMatch<Score_>> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    @Override
    public @NonNull List<ConstraintJustification> getJustificationList() {
        if (this.constraintJustificationList == null) {
            this.constraintJustificationList = this.buildConstraintJustificationList();
        }
        return this.constraintJustificationList;
    }

    private List<ConstraintJustification> buildConstraintJustificationList() {
        int constraintMatchSetSize = this.constraintMatchSet.size();
        switch (constraintMatchSetSize) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(this.constraintMatchSet.iterator().next().getJustification());
            }
        }
        Set justificationSet = CollectionUtils.newLinkedHashSet(constraintMatchSetSize);
        for (ConstraintMatch<Score_> constraintMatch : this.constraintMatchSet) {
            justificationSet.add(constraintMatch.getJustification());
        }
        return CollectionUtils.toDistinctList(justificationSet);
    }

    @Override
    public @NonNull Score_ getScore() {
        return this.score;
    }

    public void addConstraintMatch(ConstraintMatch<Score_> constraintMatch) {
        boolean added = this.addConstraintMatchWithoutFail(constraintMatch);
        if (!added) {
            throw new IllegalStateException("The indictment (" + String.valueOf(this) + ") could not add constraintMatch (" + String.valueOf(constraintMatch) + ") to its constraintMatchSet (" + String.valueOf(this.constraintMatchSet) + ").");
        }
    }

    public boolean addConstraintMatchWithoutFail(ConstraintMatch<Score_> constraintMatch) {
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (added) {
            this.score = this.score.add(constraintMatch.getScore());
            this.constraintJustificationList = null;
        }
        return added;
    }

    public void removeConstraintMatch(ConstraintMatch<Score_> constraintMatch) {
        this.score = this.score.subtract(constraintMatch.getScore());
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The indictment (" + String.valueOf(this) + ") could not remove constraintMatch (" + String.valueOf(constraintMatch) + ") from its constraintMatchSet (" + String.valueOf(this.constraintMatchSet) + ").");
        }
        this.constraintJustificationList = null;
    }

    public boolean equals(Object o) {
        if (o instanceof DefaultIndictment) {
            DefaultIndictment other = (DefaultIndictment)o;
            return this.indictedObject.equals(other.indictedObject);
        }
        return false;
    }

    public int hashCode() {
        return this.indictedObject.hashCode();
    }

    public String toString() {
        return String.valueOf(this.indictedObject) + "=" + String.valueOf(this.score);
    }
}

