/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.bi;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.IntCalculator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import org.jspecify.annotations.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class IntCalculatorBiCollector<A, B, Output_, Calculator_ extends IntCalculator<Output_>>
implements BiConstraintCollector<A, B, Calculator_, Output_> {
    private final ToIntBiFunction<? super A, ? super B> mapper;

    public IntCalculatorBiCollector(ToIntBiFunction<? super A, ? super B> mapper) {
        this.mapper = mapper;
    }

    @Override
    public @NonNull TriFunction<Calculator_, A, B, Runnable> accumulator() {
        return (calculator, a, b) -> {
            int mapped = this.mapper.applyAsInt(a, b);
            calculator.insert(mapped);
            return () -> calculator.retract(mapped);
        };
    }

    @Override
    public @NonNull Function<Calculator_, Output_> finisher() {
        return IntCalculator::result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IntCalculatorBiCollector that = (IntCalculatorBiCollector)object;
        return Objects.equals(this.mapper, that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

