/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.connected_ranges;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public final class TreeMultiSet<T>
extends AbstractSet<T> {
    private final TreeMap<T, Integer> backingMap;
    private int size;

    public TreeMultiSet(Comparator<? super T> comparator) {
        this.backingMap = new TreeMap(comparator);
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new MultiSetIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(T key) {
        this.backingMap.merge(key, 1, Integer::sum);
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Integer removed = this.backingMap.remove(o);
        if (removed != null) {
            if (removed != 1) {
                this.backingMap.put(o, removed - 1);
            }
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.backingMap.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backingMap.keySet().containsAll(c);
    }

    private final class MultiSetIterator
    implements Iterator<T> {
        T currentKey;
        int remainingForKey;

        private MultiSetIterator() {
            this.currentKey = TreeMultiSet.this.backingMap.isEmpty() ? null : TreeMultiSet.this.backingMap.firstKey();
            this.remainingForKey = this.currentKey != null ? TreeMultiSet.this.backingMap.get(this.currentKey) : 0;
        }

        @Override
        public boolean hasNext() {
            return this.remainingForKey > 0 || TreeMultiSet.this.backingMap.higherKey(this.currentKey) != null;
        }

        @Override
        public T next() {
            if (this.remainingForKey > 0) {
                --this.remainingForKey;
                return this.currentKey;
            }
            this.currentKey = TreeMultiSet.this.backingMap.higherKey(this.currentKey);
            if (this.currentKey == null) {
                throw new NoSuchElementException();
            }
            this.remainingForKey = TreeMultiSet.this.backingMap.get(this.currentKey) - 1;
            return this.currentKey;
        }

        @Override
        public void remove() {
            TreeMultiSet.this.remove(this.currentKey);
        }
    }
}

