/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.tri;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.ToIntTriFunction;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.IntCalculator;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class IntCalculatorTriCollector<A, B, C, Output_, Calculator_ extends IntCalculator<Output_>>
implements TriConstraintCollector<A, B, C, Calculator_, Output_> {
    private final ToIntTriFunction<? super A, ? super B, ? super C> mapper;

    public IntCalculatorTriCollector(ToIntTriFunction<? super A, ? super B, ? super C> mapper) {
        this.mapper = mapper;
    }

    @Override
    public @NonNull QuadFunction<Calculator_, A, B, C, Runnable> accumulator() {
        return (calculator, a, b, c) -> {
            int mapped = this.mapper.applyAsInt(a, b, c);
            calculator.insert(mapped);
            return () -> calculator.retract(mapped);
        };
    }

    @Override
    public @NonNull Function<Calculator_, Output_> finisher() {
        return IntCalculator::result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IntCalculatorTriCollector that = (IntCalculatorTriCollector)object;
        return Objects.equals(this.mapper, that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

