/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.inliner;

import ai.timefold.solver.core.api.score.buildin.bendable.BendableScore;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.inliner.BendableScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ConstraintMatchSupplier;
import ai.timefold.solver.core.impl.score.stream.common.inliner.ScoreContext;
import ai.timefold.solver.core.impl.score.stream.common.inliner.UndoScoreImpacter;

final class BendableScoreContext
extends ScoreContext<BendableScore, BendableScoreInliner> {
    private final int hardScoreLevelCount;
    private final int softScoreLevelCount;
    private final int scoreLevel;
    private final int scoreLevelWeight;

    public BendableScoreContext(BendableScoreInliner parent, AbstractConstraint<?, ?, ?> constraint, BendableScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount, int scoreLevel, int scoreLevelWeight) {
        super(parent, constraint, constraintWeight);
        this.hardScoreLevelCount = hardScoreLevelCount;
        this.softScoreLevelCount = softScoreLevelCount;
        this.scoreLevel = scoreLevel;
        this.scoreLevelWeight = scoreLevelWeight;
    }

    public BendableScoreContext(BendableScoreInliner parent, AbstractConstraint<?, ?, ?> constraint, BendableScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount) {
        this(parent, constraint, constraintWeight, hardScoreLevelCount, softScoreLevelCount, -1, -1);
    }

    public UndoScoreImpacter changeSoftScoreBy(int matchWeight, ConstraintMatchSupplier<BendableScore> constraintMatchSupplier) {
        int softImpact = this.scoreLevelWeight * matchWeight;
        int n = this.scoreLevel;
        ((BendableScoreInliner)this.parent).softScores[n] = ((BendableScoreInliner)this.parent).softScores[n] + softImpact;
        UndoScoreImpacter undoScoreImpact = () -> {
            int n = this.scoreLevel;
            ((BendableScoreInliner)this.parent).softScores[n] = ((BendableScoreInliner)this.parent).softScores[n] - softImpact;
        };
        if (!this.constraintMatchPolicy.isEnabled()) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableScore.ofSoft(this.hardScoreLevelCount, this.softScoreLevelCount, this.scoreLevel, softImpact), constraintMatchSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(int matchWeight, ConstraintMatchSupplier<BendableScore> constraintMatchSupplier) {
        int hardImpact = this.scoreLevelWeight * matchWeight;
        int n = this.scoreLevel;
        ((BendableScoreInliner)this.parent).hardScores[n] = ((BendableScoreInliner)this.parent).hardScores[n] + hardImpact;
        UndoScoreImpacter undoScoreImpact = () -> {
            int n = this.scoreLevel;
            ((BendableScoreInliner)this.parent).hardScores[n] = ((BendableScoreInliner)this.parent).hardScores[n] - hardImpact;
        };
        if (!this.constraintMatchPolicy.isEnabled()) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableScore.ofHard(this.hardScoreLevelCount, this.softScoreLevelCount, this.scoreLevel, hardImpact), constraintMatchSupplier);
    }

    public UndoScoreImpacter changeScoreBy(int matchWeight, ConstraintMatchSupplier<BendableScore> constraintMatchSupplier) {
        int[] hardImpacts = new int[this.hardScoreLevelCount];
        int[] softImpacts = new int[this.softScoreLevelCount];
        int hardScoreLevel = 0;
        while (hardScoreLevel < this.hardScoreLevelCount) {
            int hardImpact;
            hardImpacts[hardScoreLevel] = hardImpact = ((BendableScore)this.constraintWeight).hardScore(hardScoreLevel) * matchWeight;
            int n = hardScoreLevel++;
            ((BendableScoreInliner)this.parent).hardScores[n] = ((BendableScoreInliner)this.parent).hardScores[n] + hardImpact;
        }
        int softScoreLevel = 0;
        while (softScoreLevel < this.softScoreLevelCount) {
            int softImpact;
            softImpacts[softScoreLevel] = softImpact = ((BendableScore)this.constraintWeight).softScore(softScoreLevel) * matchWeight;
            int n = softScoreLevel++;
            ((BendableScoreInliner)this.parent).softScores[n] = ((BendableScoreInliner)this.parent).softScores[n] + softImpact;
        }
        UndoScoreImpacter undoScoreImpact = () -> {
            for (int hardScoreLevel = 0; hardScoreLevel < this.hardScoreLevelCount; ++hardScoreLevel) {
                int n = hardScoreLevel;
                ((BendableScoreInliner)this.parent).hardScores[n] = ((BendableScoreInliner)this.parent).hardScores[n] - hardImpacts[hardScoreLevel];
            }
            for (int softScoreLevel = 0; softScoreLevel < this.softScoreLevelCount; ++softScoreLevel) {
                int n = softScoreLevel;
                ((BendableScoreInliner)this.parent).softScores[n] = ((BendableScoreInliner)this.parent).softScores[n] - softImpacts[softScoreLevel];
            }
        };
        if (!this.constraintMatchPolicy.isEnabled()) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableScore.of(hardImpacts, softImpacts), constraintMatchSupplier);
    }
}

