/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.monitoring;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.solver.monitoring.ScoreLevels;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class SolverMetricUtil {
    private static final String UNASSIGNED_COUNT_LABEL = "unassigned.count";

    public static <Score_ extends Score<Score_>> void registerScore(SolverMetric metric, Tags tags, ScoreDefinition<Score_> scoreDefinition, Map<Tags, ScoreLevels> tagToScoreLevels, InnerScore<Score_> innerScore) {
        Number[] levelValues = innerScore.raw().toLevelNumbers();
        if (tagToScoreLevels.containsKey(tags)) {
            ScoreLevels scoreLevels = tagToScoreLevels.get(tags);
            scoreLevels.setUnassignedCount(innerScore.unassignedCount());
            for (int i = 0; i < levelValues.length; ++i) {
                scoreLevels.setLevelValue(i, levelValues[i]);
            }
        } else {
            String[] levelLabels = SolverMetricUtil.getLevelLabels(scoreDefinition);
            Number[] scoreLevels = new Number[levelLabels.length];
            System.arraycopy(levelValues, 0, scoreLevels, 0, levelValues.length);
            ScoreLevels result = new ScoreLevels(innerScore.unassignedCount(), scoreLevels);
            tagToScoreLevels.put(tags, result);
            Metrics.gauge((String)SolverMetricUtil.getGaugeName(metric, UNASSIGNED_COUNT_LABEL), (Iterable)tags, (Object)result.unassignedCount, AtomicInteger::doubleValue);
            for (int i = 0; i < levelValues.length; ++i) {
                Metrics.gauge((String)SolverMetricUtil.getGaugeName(metric, levelLabels[i]), (Iterable)tags, result.levelValues[i], ref -> ((Number)ref.get()).doubleValue());
            }
        }
    }

    private static String[] getLevelLabels(ScoreDefinition<?> scoreDefinition) {
        String[] labelNames = scoreDefinition.getLevelLabels();
        for (int i = 0; i < labelNames.length; ++i) {
            labelNames[i] = labelNames[i].replace(' ', '.');
        }
        return labelNames;
    }

    public static String getGaugeName(SolverMetric metric, String label) {
        return metric.getMeterId() + "." + label;
    }

    public static @Nullable Double getGaugeValue(MeterRegistry registry, SolverMetric metric, Tags runId) {
        return SolverMetricUtil.getGaugeValue(registry, metric.getMeterId(), runId);
    }

    public static @Nullable Double getGaugeValue(MeterRegistry registry, String meterId, Tags runId) {
        Gauge gauge = registry.find(meterId).tags((Iterable)runId).gauge();
        if (gauge != null && Double.isFinite(gauge.value())) {
            return gauge.value();
        }
        return null;
    }

    public static <Score_ extends Score<Score_>> @Nullable InnerScore<Score_> extractScore(SolverMetric metric, ScoreDefinition<Score_> scoreDefinition, Function<String, @Nullable Number> scoreLevelFunction) {
        String[] levelLabels = SolverMetricUtil.getLevelLabels(scoreDefinition);
        Number[] levelNumbers = new Number[levelLabels.length];
        for (int i = 0; i < levelLabels.length; ++i) {
            Number levelNumber = scoreLevelFunction.apply(SolverMetricUtil.getGaugeName(metric, levelLabels[i]));
            if (levelNumber == null) {
                return null;
            }
            levelNumbers[i] = levelNumber;
        }
        Score_ score = scoreDefinition.fromLevelNumbers(levelNumbers);
        Number unassignedCount = scoreLevelFunction.apply(SolverMetricUtil.getGaugeName(metric, UNASSIGNED_COUNT_LABEL));
        if (unassignedCount == null) {
            return null;
        }
        return InnerScore.withUnassignedCount(score, unassignedCount.intValue());
    }

    private SolverMetricUtil() {
    }
}

