/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.change.ProblemChangeAdapter;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractUniversalTermination;
import ai.timefold.solver.core.impl.solver.termination.ChildThreadSupportingTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class BasicPlumbingTermination<Solution_>
extends AbstractUniversalTermination<Solution_>
implements ChildThreadSupportingTermination<Solution_, SolverScope<Solution_>> {
    private final boolean daemon;
    private final BlockingQueue<ProblemChangeAdapter<Solution_>> problemChangeQueue = new LinkedBlockingQueue<ProblemChangeAdapter<Solution_>>();
    private boolean terminatedEarly = false;
    private boolean problemChangesBeingProcessed = false;

    public BasicPlumbingTermination(boolean daemon) {
        this.daemon = daemon;
    }

    public synchronized void resetTerminateEarly() {
        this.terminatedEarly = false;
    }

    public synchronized boolean terminateEarly() {
        boolean terminationEarlySuccessful = !this.terminatedEarly;
        this.terminatedEarly = true;
        this.notifyAll();
        return terminationEarlySuccessful;
    }

    public synchronized boolean isTerminateEarly() {
        return this.terminatedEarly;
    }

    public synchronized boolean waitForRestartSolverDecision() {
        if (!this.daemon) {
            return !this.problemChangeQueue.isEmpty() && !this.terminatedEarly;
        }
        while (this.problemChangeQueue.isEmpty() && !this.terminatedEarly) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Solver thread was interrupted during Object.wait().", e);
            }
        }
        return !this.terminatedEarly;
    }

    public synchronized boolean addProblemChanges(List<ProblemChangeAdapter<Solution_>> problemChangeList) {
        boolean added = this.problemChangeQueue.addAll(problemChangeList);
        this.notifyAll();
        return added;
    }

    public synchronized BlockingQueue<ProblemChangeAdapter<Solution_>> startProblemChangesProcessing() {
        this.problemChangesBeingProcessed = true;
        return this.problemChangeQueue;
    }

    public synchronized void endProblemChangesProcessing() {
        this.problemChangesBeingProcessed = false;
    }

    public synchronized boolean isEveryProblemChangeProcessed() {
        return this.problemChangeQueue.isEmpty() && !this.problemChangesBeingProcessed;
    }

    @Override
    public synchronized boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        if (Thread.currentThread().isInterrupted() && !this.terminatedEarly) {
            this.logger.info("The solver thread got interrupted, so this solver is terminating early.");
            this.terminatedEarly = true;
        }
        return this.terminatedEarly || !this.problemChangeQueue.isEmpty();
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        return -1.0;
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        return this.isSolverTerminated(phaseScope.getSolverScope());
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        return this.calculateSolverTimeGradient(phaseScope.getSolverScope());
    }

    @Override
    public Termination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return this;
    }

    public String toString() {
        return "BasicPlumbing()";
    }
}

