/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.platform.util.TestOutputEmitter;
import java.util.ArrayList;
import java.util.Locale;
import org.hamcrest.Matcher;

public final class AmbiguousViewMatcherException
extends RuntimeException
implements EspressoException {
    private Matcher<? super View> viewMatcher;
    private View rootView;
    private View view1;
    private View view2;
    private View[] others;

    /*
     * WARNING - void declaration
     */
    private AmbiguousViewMatcherException(String description) {
        super((String)var1_1);
        void var1_1;
        TestOutputEmitter.dumpThreadStates((String)"ThreadState-AmbiguousViewMatcherException.txt");
    }

    /*
     * WARNING - void declaration
     */
    private AmbiguousViewMatcherException(Builder builder) {
        super(AmbiguousViewMatcherException.getErrorMessage((Builder)var1_1));
        void var1_1;
        this.viewMatcher = ((Builder)var1_1).viewMatcher;
        this.rootView = ((Builder)var1_1).rootView;
        this.view1 = ((Builder)var1_1).view1;
        this.view2 = ((Builder)var1_1).view2;
        this.others = ((Builder)var1_1).others;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getErrorMessage(Builder builder) {
        Object object;
        if (builder.includeViewHierarchy) {
            ArrayList<View> arrayList = ImmutableSet.builder();
            View view = new View[]{((Builder)object).view1, ((Builder)object).view2};
            arrayList = ((ImmutableSet.Builder)((Object)arrayList)).add(view);
            view = ((Builder)object).others;
            arrayList = ((ImmutableSet.Builder)((Object)arrayList)).add(view);
            arrayList = ((ImmutableSet.Builder)((Object)arrayList)).build();
            view = ((Builder)object).rootView;
            arrayList = Lists.newArrayList(arrayList);
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{((Builder)object).viewMatcher};
            return HumanReadables.getViewHierarchyErrorMessage(view, arrayList, String.format(locale, "'%s' matches multiple views in the hierarchy.", objectArray), "****MATCHES****");
        }
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{((Builder)object).viewMatcher};
        return String.format(locale, "Multiple Ambiguous Views found for matcher %s", objectArray);
    }

    public static class Builder {
        private Matcher<? super View> viewMatcher;
        private View rootView;
        private View view1;
        private View view2;
        private View[] others;
        private boolean includeViewHierarchy = true;

        /*
         * WARNING - void declaration
         */
        public Builder from(AmbiguousViewMatcherException exception) {
            void var1_1;
            this.viewMatcher = ((AmbiguousViewMatcherException)var1_1).viewMatcher;
            this.rootView = ((AmbiguousViewMatcherException)var1_1).rootView;
            this.view1 = ((AmbiguousViewMatcherException)var1_1).view1;
            this.view2 = ((AmbiguousViewMatcherException)var1_1).view2;
            this.others = ((AmbiguousViewMatcherException)var1_1).others;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withViewMatcher(Matcher<? super View> viewMatcher) {
            void var1_1;
            this.viewMatcher = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withRootView(View rootView) {
            void var1_1;
            this.rootView = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withView1(View view1) {
            void var1_1;
            this.view1 = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withView2(View view2) {
            void var1_1;
            this.view2 = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withOtherAmbiguousViews(View ... others) {
            void var1_1;
            this.others = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder includeViewHierarchy(boolean includeViewHierarchy) {
            void var1_1;
            this.includeViewHierarchy = var1_1;
            return this;
        }

        public AmbiguousViewMatcherException build() {
            Preconditions.checkNotNull(this.viewMatcher);
            Preconditions.checkNotNull(this.rootView);
            Preconditions.checkNotNull(this.view1);
            Preconditions.checkNotNull(this.view2);
            Preconditions.checkNotNull(this.others);
            AmbiguousViewMatcherException ambiguousViewMatcherException = new AmbiguousViewMatcherException(this);
            return ambiguousViewMatcherException;
        }
    }
}

