/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.util.Log;
import androidx.test.espresso.AppNotIdleException;
import androidx.test.espresso.IdlingResourceTimeoutException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class IdlingPolicy {
    private static final String TAG = "IdlingPolicy";
    private final long idleTimeout;
    private final TimeUnit unit;
    private final ResponseAction errorHandler;
    private final boolean timeoutIfDebuggerAttached;
    private final boolean disableOnTimeout;

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public TimeUnit getIdleTimeoutUnit() {
        return this.unit;
    }

    public void handleTimeout(List<String> busyResources, String message) {
        Object object;
        CharSequence charSequence;
        String string;
        switch (1.$SwitchMap$androidx$test$espresso$IdlingPolicy$ResponseAction[((IdlingPolicy)object).errorHandler.ordinal()]) {
            default: {
                string = String.valueOf(string);
                charSequence = String.valueOf(string);
                int n = ((String)charSequence).length();
                StringBuilder stringBuilder = new StringBuilder(n + 24);
                object = new IllegalStateException(stringBuilder.append("should never reach here.").append(string).toString());
                throw object;
            }
            case 2: {
                object = new IdlingResourceTimeoutException((List<String>)((Object)string));
                throw object;
            }
            case 1: {
                throw AppNotIdleException.create((List<String>)((Object)string), (String)charSequence);
            }
            case 3: 
        }
        object = String.valueOf(string);
        string = String.valueOf(object);
        int n = string.length();
        charSequence = new StringBuilder(n + 30);
        Log.w((String)TAG, (String)((StringBuilder)charSequence).append("These resources are not idle: ").append((String)object).toString());
    }

    public boolean getTimeoutIfDebuggerAttached() {
        return this.timeoutIfDebuggerAttached;
    }

    public boolean getDisableOnTimeout() {
        return this.disableOnTimeout;
    }

    Builder toBuilder() {
        Builder builder = new Builder(this);
        return builder;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private IdlingPolicy(Builder builder) {
        void var1_1;
        boolean bl = ((Builder)var1_1).idleTimeout > 0L;
        Preconditions.checkArgument(bl);
        this.idleTimeout = ((Builder)var1_1).idleTimeout;
        this.unit = Preconditions.checkNotNull(((Builder)var1_1).unit);
        this.errorHandler = Preconditions.checkNotNull(((Builder)var1_1).errorHandler);
        this.timeoutIfDebuggerAttached = ((Builder)var1_1).timeoutIfDebuggerAttached;
        this.disableOnTimeout = ((Builder)var1_1).disableOnTimeout;
    }

    static class Builder {
        private long idleTimeout = -1L;
        private TimeUnit unit = null;
        private ResponseAction errorHandler = null;
        private boolean timeoutIfDebuggerAttached = false;
        private boolean disableOnTimeout;

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        private Builder(IdlingPolicy copy) {
            void var1_1;
            this.idleTimeout = ((IdlingPolicy)var1_1).idleTimeout;
            this.unit = ((IdlingPolicy)var1_1).unit;
            this.errorHandler = ((IdlingPolicy)var1_1).errorHandler;
        }

        public IdlingPolicy build() {
            IdlingPolicy idlingPolicy = new IdlingPolicy(this);
            return idlingPolicy;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withTimeoutIfDebuggerAttached(boolean timeoutIfDebuggerAttached) {
            void var1_1;
            this.timeoutIfDebuggerAttached = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withDisableOnTimeout(boolean disableOnTimeout) {
            void var1_1;
            this.disableOnTimeout = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withIdlingTimeout(long idleTimeout) {
            void var1_1;
            this.idleTimeout = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withIdlingTimeoutUnit(TimeUnit unit) {
            void var1_1;
            this.unit = var1_1;
            return this;
        }

        public Builder throwAppNotIdleException() {
            this.errorHandler = ResponseAction.THROW_APP_NOT_IDLE;
            return this;
        }

        public Builder throwIdlingResourceTimeoutException() {
            this.errorHandler = ResponseAction.THROW_IDLE_TIMEOUT;
            return this;
        }

        public Builder logWarning() {
            this.errorHandler = ResponseAction.LOG_ERROR;
            return this;
        }
    }

    private static final class ResponseAction
    extends Enum<ResponseAction> {
        public static final /* enum */ ResponseAction THROW_APP_NOT_IDLE;
        public static final /* enum */ ResponseAction THROW_IDLE_TIMEOUT;
        public static final /* enum */ ResponseAction LOG_ERROR;
        private static final /* synthetic */ ResponseAction[] $VALUES;

        public static ResponseAction[] values() {
            return (ResponseAction[])$VALUES.clone();
        }

        public static ResponseAction valueOf(String name) {
            String string;
            return Enum.valueOf(ResponseAction.class, string);
        }

        static {
            ResponseAction responseAction;
            THROW_APP_NOT_IDLE = responseAction = new ResponseAction();
            THROW_IDLE_TIMEOUT = responseAction = new ResponseAction();
            LOG_ERROR = responseAction = new ResponseAction();
            $VALUES = responseActionArray = new ResponseAction[]{ResponseAction.THROW_APP_NOT_IDLE, ResponseAction.THROW_IDLE_TIMEOUT, ResponseAction.LOG_ERROR};
        }
    }
}

