/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.InteractionResultsHandler;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.action.ScrollToAction;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.MainThread;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableMap;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFutureTask;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListeningExecutorService;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.Bindable;
import androidx.test.espresso.remote.IInteractionExecutionStatus;
import androidx.test.espresso.remote.RemoteInteraction;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.internal.util.LogUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class ViewInteraction {
    private static final String TAG = ViewInteraction.class.getSimpleName();
    private final InterruptableUiController uiController;
    private final ViewFinder viewFinder;
    private final Executor mainThreadExecutor;
    private final ControlledLooper controlledLooper;
    private volatile FailureHandler failureHandler;
    private final Matcher<View> viewMatcher;
    private final AtomicReference<Matcher<Root>> rootMatcherRef;
    private final AtomicReference<Boolean> needsActivity;
    private final RemoteInteraction remoteInteraction;
    private final ListeningExecutorService remoteExecutor;
    private boolean hasRootMatcher = false;

    /*
     * WARNING - void declaration
     */
    ViewInteraction(UiController uiController, ViewFinder viewFinder, @MainThread Executor mainThreadExecutor, FailureHandler failureHandler, Matcher<View> viewMatcher, AtomicReference<Matcher<Root>> rootMatcherRef, AtomicReference<Boolean> needsActivity, RemoteInteraction remoteInteraction, ListeningExecutorService remoteExecutor, ControlledLooper controlledLooper) {
        void var10_10;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var3_3;
        void var4_4;
        void var1_1;
        void var2_2;
        this.viewFinder = (ViewFinder)Preconditions.checkNotNull(var2_2);
        this.uiController = (InterruptableUiController)Preconditions.checkNotNull(var1_1);
        this.failureHandler = (FailureHandler)Preconditions.checkNotNull(var4_4);
        this.mainThreadExecutor = (Executor)Preconditions.checkNotNull(var3_3);
        this.viewMatcher = (Matcher)Preconditions.checkNotNull(var5_5);
        this.rootMatcherRef = (AtomicReference)Preconditions.checkNotNull(var6_6);
        this.needsActivity = (AtomicReference)Preconditions.checkNotNull(var7_7);
        this.remoteInteraction = (RemoteInteraction)Preconditions.checkNotNull(var8_8);
        this.remoteExecutor = (ListeningExecutorService)Preconditions.checkNotNull(var9_9);
        this.controlledLooper = (ControlledLooper)Preconditions.checkNotNull(var10_10);
    }

    /*
     * WARNING - void declaration
     */
    public ViewInteraction perform(ViewAction ... viewActions) {
        void var1_1;
        Preconditions.checkNotNull(viewActions);
        for (void var4_4 : var1_1) {
            SingleExecutionViewAction singleExecutionViewAction = new SingleExecutionViewAction((ViewAction)var4_4, this.viewMatcher);
            this.desugaredPerform(singleExecutionViewAction);
        }
        return this;
    }

    private static Map<String, IBinder> getIBindersFromBindables(List<Bindable> bindables) {
        Iterator<Bindable> iterator;
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Bindable bindable = (Bindable)iterator.next();
            hashMap.put(Preconditions.checkNotNull(bindable.getId(), "Bindable id cannot be null!"), Preconditions.checkNotNull(bindable.getIBinder(), "Bindable binder cannot be null!"));
        }
        return ImmutableMap.copyOf(hashMap);
    }

    private static List<Bindable> getBindables(Object ... objects) {
        Object[] objectArray;
        ArrayList<Bindable> arrayList = Lists.newArrayListWithCapacity(objects.length);
        for (Object object : objectArray) {
            if (!(object instanceof Bindable)) continue;
            arrayList.add((Bindable)object);
        }
        return arrayList;
    }

    private static Map<String, IBinder> getIBindersFromViewActions(ViewAction ... viewActions) {
        return ViewInteraction.getIBindersFromBindables(ViewInteraction.getBindables(viewActions));
    }

    private static Map<String, IBinder> getIBindersFromViewAssertions(ViewAssertion ... viewAssertions) {
        return ViewInteraction.getIBindersFromBindables(ViewInteraction.getBindables(viewAssertions));
    }

    private void desugaredPerform(SingleExecutionViewAction va) {
        Map<String, IBinder> map;
        Callable<Void> callable = new Callable<Void>(this, (SingleExecutionViewAction)((Object)map)){
            final /* synthetic */ SingleExecutionViewAction val$va;
            final /* synthetic */ ViewInteraction this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$va = singleExecutionViewAction;
            }

            @Override
            public Void call() {
                ViewInteraction.access$100(this.this$0, this.val$va);
                return null;
            }
        };
        ViewAction viewAction = ((SingleExecutionViewAction)((Object)map)).getInnerViewAction();
        ArrayList<ListenableFuture<Void>> arrayList = new ArrayList<ListenableFuture<Void>>();
        arrayList.add(this.postAsynchronouslyOnUiThread(callable));
        if (!this.remoteInteraction.isRemoteProcess()) {
            callable = this.remoteExecutor;
            RemoteInteraction remoteInteraction = this.remoteInteraction;
            Matcher matcher = this.rootMatcherRef;
            matcher = matcher.get();
            matcher = matcher;
            Matcher<View> matcher2 = this.viewMatcher;
            ViewAction[] viewActionArray = new ViewAction[]{map, viewAction};
            map = ViewInteraction.getIBindersFromViewActions(viewActionArray);
            viewActionArray = new ViewAction[]{viewAction};
            arrayList.add(callable.submit(remoteInteraction.createRemotePerformCallable((Matcher<Root>)matcher, matcher2, map, viewActionArray)));
        }
        this.waitForAndHandleInteractionResults(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    public ViewInteraction withFailureHandler(FailureHandler failureHandler) {
        void var1_1;
        this.failureHandler = (FailureHandler)Preconditions.checkNotNull(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ViewInteraction inRoot(Matcher<Root> rootMatcher) {
        void var1_1;
        this.hasRootMatcher = true;
        this.rootMatcherRef.set((Matcher<Root>)((Matcher)Preconditions.checkNotNull(var1_1)));
        return this;
    }

    public ViewInteraction noActivity() {
        if (!this.hasRootMatcher) {
            this.rootMatcherRef.set((Matcher<Root>)Matchers.anyOf(RootMatchers.DEFAULT, (Matcher)Matchers.allOf(RootMatchers.hasWindowLayoutParams(), RootMatchers.isSystemAlertWindow())));
        }
        this.needsActivity.set(false);
        return this;
    }

    private void doPerform(SingleExecutionViewAction viewAction) {
        Object object;
        Preconditions.checkNotNull(viewAction);
        Object object2 = Preconditions.checkNotNull(((SingleExecutionViewAction)object).getConstraints());
        ((ViewInteraction)object3).uiController.loopMainThreadUntilIdle();
        View view = ((ViewInteraction)object3).viewFinder.getView();
        String string = TAG;
        Serializable serializable = Locale.ROOT;
        Object[] objectArray = new Object[]{((SingleExecutionViewAction)object).getDescription(), ((ViewInteraction)object3).viewMatcher};
        Log.i((String)string, (String)String.format(serializable, "Performing '%s' action on view %s", objectArray));
        if (!object2.matches((Object)view)) {
            serializable = new StringBuilder("Action will not be performed because the target view does not match one or more of the following constraints:\n");
            string = new StringDescription((Appendable)((Object)serializable));
            object2.describeTo((Description)string);
            string.appendText("\nTarget view: ").appendValue((Object)HumanReadables.describe(view));
            if (((SingleExecutionViewAction)object).getInnerViewAction() instanceof ScrollToAction && ViewMatchers.isDescendantOfA(ViewMatchers.isAssignableFrom(AdapterView.class)).matches((Object)view)) {
                string.appendText("\nFurther Info: ScrollToAction on a view inside an AdapterView will not work. Use Espresso.onData to load the view.");
            }
            object2 = new PerformException.Builder();
            object = ((SingleExecutionViewAction)object).getDescription();
            object = ((PerformException.Builder)object2).withActionDescription((String)object);
            Object object3 = ((ViewInteraction)object3).viewMatcher;
            object3 = object3.toString();
            object3 = ((PerformException.Builder)object).withViewDescription((String)object3);
            object = new RuntimeException(string.toString());
            throw ((PerformException.Builder)object3).withCause((Throwable)object).build();
        }
        ((SingleExecutionViewAction)object).perform(((ViewInteraction)object3).uiController, view);
    }

    /*
     * WARNING - void declaration
     */
    public ViewInteraction check(ViewAssertion viewAssert) {
        void var1_1;
        Preconditions.checkNotNull(viewAssert);
        SingleExecutionViewAssertion singleExecutionViewAssertion = new SingleExecutionViewAssertion((ViewAssertion)var1_1);
        Callable<Void> callable = new Callable<Void>(this, (ViewAssertion)var1_1, singleExecutionViewAssertion){
            final /* synthetic */ ViewAssertion val$viewAssert;
            final /* synthetic */ SingleExecutionViewAssertion val$singleExecutionViewAssertion;
            final /* synthetic */ ViewInteraction this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$viewAssert = viewAssertion;
                this.val$singleExecutionViewAssertion = singleExecutionViewAssertion;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void call() {
                NoMatchingViewException noMatchingViewException;
                View view;
                this.this$0.uiController.loopMainThreadUntilIdle();
                try {
                    view = this.this$0.viewFinder.getView();
                    noMatchingViewException = null;
                }
                catch (NoMatchingViewException noMatchingViewException2) {
                    view = null;
                }
                String string = TAG;
                Locale locale = Locale.ROOT;
                Object[] objectArray = new Object[]{this.val$viewAssert, this.this$0.viewMatcher};
                Log.i((String)string, (String)String.format(locale, "Checking '%s' assertion on view %s", objectArray));
                this.val$singleExecutionViewAssertion.check(view, noMatchingViewException);
                return null;
            }
        };
        ArrayList<ListenableFuture<Void>> arrayList = new ArrayList<ListenableFuture<Void>>();
        arrayList.add(this.postAsynchronouslyOnUiThread(callable));
        if (!this.remoteInteraction.isRemoteProcess()) {
            callable = this.remoteExecutor;
            RemoteInteraction remoteInteraction = this.remoteInteraction;
            Matcher matcher = this.rootMatcherRef;
            matcher = matcher.get();
            matcher = matcher;
            Matcher<View> matcher2 = this.viewMatcher;
            ViewAssertion[] viewAssertionArray = new ViewAssertion[]{singleExecutionViewAssertion, var1_1};
            arrayList.add(callable.submit(remoteInteraction.createRemoteCheckCallable((Matcher<Root>)matcher, matcher2, ViewInteraction.getIBindersFromViewAssertions(viewAssertionArray), (ViewAssertion)var1_1)));
        }
        this.waitForAndHandleInteractionResults(arrayList);
        return this;
    }

    private ListenableFuture<Void> postAsynchronouslyOnUiThread(Callable<Void> interaction) {
        ListenableFutureTask<Void> listenableFutureTask = ListenableFutureTask.create(interaction);
        this.mainThreadExecutor.execute(listenableFutureTask);
        return listenableFutureTask;
    }

    /*
     * WARNING - void declaration
     */
    private void waitForAndHandleInteractionResults(List<ListenableFuture<Void>> interactions) {
        try {
            void var1_1;
            this.controlledLooper.drainMainThreadUntilIdle();
            InteractionResultsHandler.gatherAnyResult(var1_1);
            return;
        }
        catch (RuntimeException runtimeException) {
            this.failureHandler.handle(runtimeException, this.viewMatcher);
            return;
        }
        catch (Error error) {
            this.failureHandler.handle(error, this.viewMatcher);
        }
        finally {
            this.uiController.interruptEspressoTasks();
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(ViewInteraction x0, SingleExecutionViewAction x1) {
        void var1_1;
        x0.doPerform((SingleExecutionViewAction)var1_1);
    }

    private static final class SingleExecutionViewAssertion
    implements ViewAssertion,
    Bindable {
        final ViewAssertion viewAssertion;
        private IInteractionExecutionStatus assertionExecutionStatus;

        /*
         * WARNING - void declaration
         */
        private SingleExecutionViewAssertion(ViewAssertion viewAssertion) {
            void var1_1;
            IInteractionExecutionStatus.Stub stub = new IInteractionExecutionStatus.Stub(this){
                AtomicBoolean run;
                {
                    this.run = object = new AtomicBoolean(true);
                }

                @Override
                public boolean canExecute() throws RemoteException {
                    return this.run.getAndSet(false);
                }
            };
            this.assertionExecutionStatus = stub;
            this.viewAssertion = var1_1;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void check(View view, NoMatchingViewException noViewFoundException) {
            Object object;
            try {
                void var2_3;
                boolean bl = ((SingleExecutionViewAssertion)this_).assertionExecutionStatus.canExecute();
                if (!bl) {
                    object = TAG;
                    Object this_ = String.valueOf(((SingleExecutionViewAssertion)this_).viewAssertion);
                    int n = String.valueOf(this_).length();
                    StringBuilder stringBuilder = new StringBuilder(n += 66);
                    this_ = stringBuilder.append("Attempted to execute a Single Execution Assertion more then once: ").append((String)this_).toString();
                    Object[] objectArray = new Object[]{};
                    LogUtil.logDebugWithProcess((String)object, (String)this_, (Object[])objectArray);
                    return;
                }
                ((SingleExecutionViewAssertion)this_).viewAssertion.check((View)object, (NoMatchingViewException)var2_3);
                return;
            }
            catch (RemoteException remoteException) {
                object = new RuntimeException("Unable to query interaction execution status", remoteException.getCause());
                throw object;
            }
        }

        @Override
        public String getId() {
            return "executionStatus";
        }

        @Override
        public IBinder getIBinder() {
            return this.assertionExecutionStatus.asBinder();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setIBinder(IBinder binder) {
            void var1_1;
            this.assertionExecutionStatus = IInteractionExecutionStatus.Stub.asInterface((IBinder)var1_1);
        }
    }

    private static final class SingleExecutionViewAction
    implements ViewAction,
    Bindable {
        final ViewAction viewAction;
        final Matcher<View> viewMatcher;
        private IInteractionExecutionStatus actionExecutionStatus;

        /*
         * WARNING - void declaration
         */
        private SingleExecutionViewAction(ViewAction viewAction, Matcher<View> viewMatcher) {
            void var2_2;
            void var1_1;
            IInteractionExecutionStatus.Stub stub = new IInteractionExecutionStatus.Stub(this){
                AtomicBoolean run;
                {
                    this.run = object = new AtomicBoolean(true);
                }

                @Override
                public boolean canExecute() throws RemoteException {
                    return this.run.getAndSet(false);
                }
            };
            this.actionExecutionStatus = stub;
            this.viewAction = var1_1;
            this.viewMatcher = var2_2;
        }

        @Override
        public Matcher<View> getConstraints() {
            return this.viewAction.getConstraints();
        }

        @Override
        public String getDescription() {
            return this.viewAction.getDescription();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void perform(UiController uiController, View view) {
            Object object;
            try {
                String string;
                int n = ((SingleExecutionViewAction)this_).actionExecutionStatus.canExecute();
                if (n == 0) {
                    string = TAG;
                    object = String.valueOf(((SingleExecutionViewAction)this_).viewAction);
                    n = String.valueOf(object).length();
                    StringBuilder stringBuilder = new StringBuilder(n += 63);
                    object = stringBuilder.append("Attempted to execute a Single Execution Action more then once: ").append((String)object).toString();
                    Object[] objectArray = new Object[]{};
                    LogUtil.logDebugWithProcess((String)string, (String)object, (Object[])objectArray);
                    return;
                }
                ((SingleExecutionViewAction)this_).viewAction.perform((UiController)((Object)string), (View)object);
                return;
            }
            catch (RemoteException remoteException) {
                object = new PerformException.Builder();
                Object object2 = ((SingleExecutionViewAction)this_).viewAction;
                object2 = object2.getDescription();
                object = ((PerformException.Builder)object).withActionDescription((String)object2);
                Object this_ = ((SingleExecutionViewAction)this_).viewMatcher;
                this_ = this_.toString();
                this_ = ((PerformException.Builder)object).withViewDescription((String)this_);
                object = new RuntimeException("Unable to query interaction execution status", remoteException.getCause());
                throw ((PerformException.Builder)this_).withCause((Throwable)object).build();
            }
        }

        ViewAction getInnerViewAction() {
            return this.viewAction;
        }

        @Override
        public String getId() {
            return "executionStatus";
        }

        @Override
        public IBinder getIBinder() {
            return this.actionExecutionStatus.asBinder();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setIBinder(IBinder binder) {
            void var1_1;
            this.actionExecutionStatus = IInteractionExecutionStatus.Stub.asInterface((IBinder)var1_1);
        }
    }
}

