/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.graphics.Rect;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.assertion.ViewAssertions;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.LayoutMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.LinkedList;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class LayoutAssertions {
    private LayoutAssertions() {
    }

    public static ViewAssertion noEllipsizedText() {
        return ViewAssertions.selectedDescendantsMatch(ViewMatchers.isAssignableFrom(TextView.class), (Matcher<View>)Matchers.not(LayoutMatchers.hasEllipsizedText()));
    }

    public static ViewAssertion noMultilineButtons() {
        return ViewAssertions.selectedDescendantsMatch(ViewMatchers.isAssignableFrom(Button.class), (Matcher<View>)Matchers.not(LayoutMatchers.hasMultilineText()));
    }

    public static ViewAssertion noOverlaps(Matcher<View> selector) {
        Matcher<View> matcher;
        NoOverlapsViewAssertion noOverlapsViewAssertion = new NoOverlapsViewAssertion(Preconditions.checkNotNull(matcher));
        return noOverlapsViewAssertion;
    }

    public static ViewAssertion noOverlaps() {
        return LayoutAssertions.noOverlaps((Matcher<View>)Matchers.allOf(ViewMatchers.withEffectiveVisibility(ViewMatchers.Visibility.VISIBLE), (Matcher)Matchers.anyOf(ViewMatchers.isAssignableFrom(TextView.class), ViewMatchers.isAssignableFrom(ImageView.class))));
    }

    private static Rect getRect(View view) {
        View view2;
        int[] nArray = new int[]{0, 0};
        view2.getLocationOnScreen(nArray);
        Rect rect = new Rect(nArray[0], nArray[1], nArray[0] + view2.getWidth() + -1, nArray[1] + view2.getHeight() + -1);
        return rect;
    }

    static class NoOverlapsViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        private final Matcher<View> selector;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private NoOverlapsViewAssertion(Matcher<View> selector) {
            void var1_1;
            this.selector = var1_1;
        }

        @Override
        public void check(View view, NoMatchingViewException noViewException) {
            LinkedList<1> linkedList;
            StringBuilder stringBuilder;
            View view2 = new Predicate<View>((NoOverlapsViewAssertion)object){
                final /* synthetic */ NoOverlapsViewAssertion this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean apply(View input) {
                    void var1_1;
                    return this.this$0.selector.matches((Object)var1_1);
                }
            };
            if (stringBuilder != null) {
                throw stringBuilder;
            }
            Object object = Iterables.filter(TreeIterables.breadthFirstViewTraversal((View)linkedList), view2).iterator();
            linkedList = new LinkedList<1>();
            stringBuilder = new StringBuilder();
            while (object.hasNext()) {
                view2 = (View)object.next();
                Object object2 = LayoutAssertions.getRect(view2);
                if (object2.isEmpty() || view2 instanceof TextView && ((TextView)view2).getText().length() == 0) continue;
                Object[] objectArray = linkedList.iterator();
                while (objectArray.hasNext()) {
                    View view3 = (View)objectArray.next();
                    if (view2 instanceof ImageView && view3 instanceof ImageView || !Rect.intersects((Rect)object2, (Rect)LayoutAssertions.getRect(view3))) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",\n\n");
                    }
                    object2 = Locale.ROOT;
                    objectArray = new Object[]{HumanReadables.describe(view2), HumanReadables.describe(view3)};
                    stringBuilder.append(String.format((Locale)object2, "%s overlaps\n%s", objectArray));
                    break;
                }
                linkedList.add(view2);
            }
            if (stringBuilder.length() > 0) {
                object = new AssertionFailedError(stringBuilder.toString());
                throw object;
            }
        }

        public String toString() {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.selector};
            return String.format(locale, "NoOverlapsViewAssertion{selector=%s}", objectArray);
        }
    }
}

