/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.test.espresso.IdlingPolicies;
import androidx.test.espresso.IdlingPolicy;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.LooperIdlingResourceInterrogationHandler;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public final class IdlingResourceRegistry {
    private static final String TAG = IdlingResourceRegistry.class.getSimpleName();
    private static final int DYNAMIC_RESOURCE_HAS_IDLED = 1;
    private static final int TIMEOUT_OCCURRED = 2;
    private static final int IDLE_WARNING_REACHED = 3;
    private static final int POSSIBLE_RACE_CONDITION_DETECTED = 4;
    private static final Object TIMEOUT_MESSAGE_TAG;
    private static final IdleNotificationCallback NO_OP_CALLBACK;
    private final List<IdlingState> idlingStates;
    private final Looper looper;
    private final Handler handler;
    private final Dispatcher dispatcher;
    private IdleNotificationCallback idleNotificationCallback;

    /*
     * WARNING - void declaration
     */
    public IdlingResourceRegistry(Looper looper) {
        void var1_1;
        Object object = new ArrayList();
        this.idlingStates = object;
        this.idleNotificationCallback = NO_OP_CALLBACK;
        this.looper = var1_1;
        this.dispatcher = object = new Dispatcher();
        object = new Handler((Looper)var1_1, (Handler.Callback)this.dispatcher);
        this.handler = object;
    }

    public void sync(Iterable<IdlingResource> resources, Iterable<Looper> loopers) {
        LooperIdlingResourceInterrogationHandler looperIdlingResourceInterrogationHandler;
        ArrayList<IdlingResource> arrayList;
        if (Looper.myLooper() != this.looper) {
            Callable<Void> callable = new Callable<Void>(this, (Iterable)arrayList, (Iterable)((Object)looperIdlingResourceInterrogationHandler)){
                final /* synthetic */ Iterable val$resources;
                final /* synthetic */ Iterable val$loopers;
                final /* synthetic */ IdlingResourceRegistry this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$resources = iterable;
                    this.val$loopers = iterable2;
                }

                @Override
                public Void call() {
                    this.this$0.sync(this.val$resources, this.val$loopers);
                    return null;
                }
            };
            this.runSynchronouslyOnMainThread(callable);
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (IdlingResource object : arrayList) {
            if (hashMap.containsKey(object.getName())) {
                this.logDuplicateRegistrationError(object, (IdlingResource)hashMap.get(object.getName()));
                continue;
            }
            hashMap.put(object.getName(), object);
        }
        arrayList = looperIdlingResourceInterrogationHandler.iterator();
        while (arrayList.hasNext()) {
            looperIdlingResourceInterrogationHandler = LooperIdlingResourceInterrogationHandler.forLooper((Looper)arrayList.next());
            if (hashMap.containsKey(looperIdlingResourceInterrogationHandler.getName())) {
                this.logDuplicateRegistrationError(looperIdlingResourceInterrogationHandler, (IdlingResource)hashMap.get(looperIdlingResourceInterrogationHandler.getName()));
                continue;
            }
            hashMap.put(looperIdlingResourceInterrogationHandler.getName(), looperIdlingResourceInterrogationHandler);
        }
        arrayList = new ArrayList<IdlingResource>();
        for (IdlingState idlingState : this.idlingStates) {
            IdlingResource idlingResource = (IdlingResource)hashMap.remove(idlingState.resource.getName());
            if (idlingResource == null) {
                arrayList.add(idlingState.resource);
                continue;
            }
            if (idlingState.resource == idlingResource) continue;
            arrayList.add(idlingState.resource);
            hashMap.put(idlingResource.getName(), idlingResource);
        }
        this.unregisterResources(arrayList);
        this.registerResources(Lists.newArrayList(hashMap.values()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean registerResources(List<? extends IdlingResource> resourceList) {
        void var1_1;
        if (Looper.myLooper() != this.looper) {
            Callable<Boolean> callable = new Callable<Boolean>(this, (List)var1_1){
                final /* synthetic */ List val$resourceList;
                final /* synthetic */ IdlingResourceRegistry this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$resourceList = list;
                }

                @Override
                public Boolean call() {
                    return this.this$0.registerResources(this.val$resourceList);
                }
            };
            return this.runSynchronouslyOnMainThread(callable);
        }
        Iterator iterator = var1_1.iterator();
        boolean bl = true;
        while (true) {
            boolean bl2;
            IdlingResource idlingResource;
            block5: {
                if (!iterator.hasNext()) {
                    return bl;
                }
                idlingResource = (IdlingResource)iterator.next();
                Preconditions.checkNotNull(idlingResource.getName(), "IdlingResource.getName() should not be null");
                for (IdlingState idlingState : this.idlingStates) {
                    if (!idlingResource.getName().equals(idlingState.resource.getName())) continue;
                    this.logDuplicateRegistrationError(idlingResource, idlingState.resource);
                    bl2 = true;
                    break block5;
                }
                bl2 = false;
            }
            if (!bl2) {
                IdlingState idlingState = new IdlingState(idlingResource, this.handler);
                this.idlingStates.add(idlingState);
                idlingState.registerSelf();
                continue;
            }
            bl = false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean unregisterResources(List<? extends IdlingResource> resourceList) {
        void var1_1;
        if (Looper.myLooper() != this.looper) {
            Callable<Boolean> callable = new Callable<Boolean>(this, (List)var1_1){
                final /* synthetic */ List val$resourceList;
                final /* synthetic */ IdlingResourceRegistry this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$resourceList = list;
                }

                @Override
                public Boolean call() {
                    return this.this$0.unregisterResources(this.val$resourceList);
                }
            };
            return this.runSynchronouslyOnMainThread(callable);
        }
        Iterator iterator = var1_1.iterator();
        boolean bl = true;
        while (true) {
            int n;
            IdlingResource idlingResource;
            block4: {
                if (!iterator.hasNext()) {
                    return bl;
                }
                idlingResource = (IdlingResource)iterator.next();
                for (n = 0; n < this.idlingStates.size(); ++n) {
                    if (!this.idlingStates.get((int)n).resource.getName().equals(idlingResource.getName())) continue;
                    this.idlingStates.remove(n);
                    n = 1;
                    break block4;
                }
                n = 0;
            }
            if (n != 0) continue;
            String string = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{idlingResource.getName(), this.getResources()};
            Log.e((String)string, (String)String.format(locale, "Attempted to unregister resource that is not registered: '%s'. Resource list: %s", objectArray));
            bl = false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void registerLooper(Looper looper, boolean bl) {
        void var1_1;
        Preconditions.checkNotNull(looper);
        bl = Looper.getMainLooper() != var1_1;
        Preconditions.checkArgument(bl, "Not intended for use with main looper!");
        LooperIdlingResourceInterrogationHandler[] looperIdlingResourceInterrogationHandlerArray = new LooperIdlingResourceInterrogationHandler[]{LooperIdlingResourceInterrogationHandler.forLooper((Looper)var1_1)};
        this.registerResources(Lists.newArrayList(looperIdlingResourceInterrogationHandlerArray));
    }

    public List<IdlingResource> getResources() {
        if (Looper.myLooper() != ((IdlingResourceRegistry)((Object)iterator)).looper) {
            Callable<List<IdlingResource>> callable = new Callable<List<IdlingResource>>((IdlingResourceRegistry)((Object)iterator)){
                final /* synthetic */ IdlingResourceRegistry this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public List<IdlingResource> call() {
                    return this.this$0.getResources();
                }
            };
            return ((IdlingResourceRegistry)((Object)iterator)).runSynchronouslyOnMainThread(callable);
        }
        ImmutableList.Builder<IdlingResource> builder = ImmutableList.builder();
        Iterator<IdlingState> iterator = ((IdlingResourceRegistry)((Object)iterator)).idlingStates.iterator();
        while (iterator.hasNext()) {
            builder.add(((IdlingState)iterator.next()).resource);
        }
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean allResourcesAreIdle() {
        boolean bl = Looper.myLooper() == ((IdlingResourceRegistry)this).looper;
        Preconditions.checkState(bl);
        for (IdlingState idlingState : ((IdlingResourceRegistry)this).idlingStates) {
            if (idlingState.idle) {
                idlingState.idle = idlingState.resource.isIdleNow();
            }
            if (idlingState.idle) continue;
            return false;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"All idling resources are idle.");
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    void notifyWhenAllResourcesAreIdle(IdleNotificationCallback callback) {
        void var1_1;
        Preconditions.checkNotNull(callback);
        boolean bl = Looper.myLooper() == this.looper;
        Preconditions.checkState(bl);
        bl = this.idleNotificationCallback == NO_OP_CALLBACK;
        Preconditions.checkState(bl, "Callback has already been registered.");
        if (this.allResourcesAreIdle()) {
            var1_1.allResourcesIdle();
            return;
        }
        this.idleNotificationCallback = var1_1;
        this.scheduleTimeoutMessages();
    }

    IdleNotifier<IdleNotificationCallback> asIdleNotifier() {
        IdleNotifier<IdleNotificationCallback> idleNotifier = new IdleNotifier<IdleNotificationCallback>(this){
            final /* synthetic */ IdlingResourceRegistry this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public boolean isIdleNow() {
                return this.this$0.allResourcesAreIdle();
            }

            @Override
            public void cancelCallback() {
                this.this$0.cancelIdleMonitor();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void registerNotificationCallback(IdleNotificationCallback cb) {
                void var1_1;
                this.this$0.notifyWhenAllResourcesAreIdle((IdleNotificationCallback)var1_1);
            }
        };
        return idleNotifier;
    }

    void cancelIdleMonitor() {
        this.dispatcher.deregister();
    }

    private <T> T runSynchronouslyOnMainThread(Callable<T> task) {
        RuntimeException runtimeException;
        FutureTask futureTask = new FutureTask(runtimeException);
        idlingResourceRegistry.handler.post(futureTask);
        try {
            IdlingResourceRegistry idlingResourceRegistry = futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            runtimeException = new RuntimeException(interruptedException);
            throw runtimeException;
        }
        catch (CancellationException cancellationException) {
            runtimeException = new RuntimeException(cancellationException);
            throw runtimeException;
        }
        catch (ExecutionException executionException) {
            runtimeException = new RuntimeException(executionException);
            throw runtimeException;
        }
        return (T)idlingResourceRegistry;
    }

    private void scheduleTimeoutMessages() {
        IdlingPolicy idlingPolicy = IdlingPolicies.getDynamicIdlingResourceWarningPolicy();
        Object object = this.handler;
        Object object2 = TIMEOUT_MESSAGE_TAG;
        object = object.obtainMessage(3, object2);
        this.handler.sendMessageDelayed((Message)object, idlingPolicy.getIdleTimeoutUnit().toMillis(idlingPolicy.getIdleTimeout()));
        idlingPolicy = this.handler;
        object = TIMEOUT_MESSAGE_TAG;
        idlingPolicy = idlingPolicy.obtainMessage(2, object);
        object = IdlingPolicies.getDynamicIdlingResourceErrorPolicy();
        this.handler.sendMessageDelayed((Message)idlingPolicy, ((IdlingPolicy)object).getIdleTimeoutUnit().toMillis(((IdlingPolicy)object).getIdleTimeout()));
    }

    private List<String> getBusyResources() {
        Message message = Lists.newArrayList();
        ArrayList<IdlingState> arrayList = Lists.newArrayList();
        for (IdlingState idlingState : this.idlingStates) {
            if (idlingState.idle) continue;
            if (idlingState.resource.isIdleNow()) {
                arrayList.add(idlingState);
                continue;
            }
            message.add(idlingState.resource.getName());
        }
        if (!arrayList.isEmpty()) {
            message = this.handler.obtainMessage(4, TIMEOUT_MESSAGE_TAG);
            message.obj = arrayList;
            this.handler.sendMessage(message);
            return null;
        }
        return message;
    }

    /*
     * WARNING - void declaration
     */
    private void logDuplicateRegistrationError(IdlingResource newResource, IdlingResource oldResource) {
        void var2_2;
        void var1_1;
        String string = TAG;
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{var1_1.getName(), var1_1, var2_2};
        Log.e((String)string, (String)String.format(locale, "Attempted to register resource with same names: %s. R1: %s R2: %s.\nDuplicate resource registration will be ignored.", objectArray));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ IdleNotificationCallback access$602(IdlingResourceRegistry x0, IdleNotificationCallback x1) {
        void var1_1;
        x0.idleNotificationCallback = var1_1;
        return var1_1;
    }

    static {
        IdleNotificationCallback idleNotificationCallback = new Object();
        TIMEOUT_MESSAGE_TAG = idleNotificationCallback;
        idleNotificationCallback = new IdleNotificationCallback(){

            @Override
            public void allResourcesIdle() {
            }

            @Override
            public void resourcesStillBusyWarning(List<String> list) {
            }

            @Override
            public void resourcesHaveTimedOut(List<String> list) {
            }
        };
        NO_OP_CALLBACK = idleNotificationCallback;
    }

    private class Dispatcher
    implements Handler.Callback {
        private Dispatcher() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean handleMessage(Message m) {
            String string;
            switch (m.what) {
                case 4: {
                    ((Dispatcher)((Object)string2)).handleRaceCondition((Message)string);
                    return true;
                }
                case 3: {
                    ((Dispatcher)((Object)string2)).handleTimeoutWarning();
                    return true;
                }
                case 2: {
                    ((Dispatcher)((Object)string2)).handleTimeout();
                    return true;
                }
                case 1: {
                    ((Dispatcher)((Object)string2)).handleResourceIdled((Message)string);
                    return true;
                }
            }
            String string2 = TAG;
            string = String.valueOf(string);
            String string3 = String.valueOf(string);
            int n = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 22);
            Log.w((String)string2, (String)stringBuilder.append("Unknown message type: ").append(string).toString());
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleResourceIdled(Message m) {
            Object object = (IdlingState)m.obj;
            ((IdlingState)object).idle = true;
            Iterator iterator = ((Dispatcher)((Object)string)).IdlingResourceRegistry.this.idlingStates.iterator();
            boolean bl = true;
            boolean bl2 = true;
            while (iterator.hasNext()) {
                IdlingState idlingState = (IdlingState)iterator.next();
                bl2 = bl2 && idlingState.idle;
                if (!bl && !bl2) break;
                if (!bl || idlingState != object) continue;
                bl = false;
            }
            if (bl) {
                String string = TAG;
                String string2 = String.valueOf(((IdlingState)object).resource);
                String string3 = String.valueOf(string2);
                int n = string3.length();
                object = new StringBuilder(n + 45);
                Log.i((String)string, (String)((StringBuilder)object).append("Ignoring message from unregistered resource: ").append(string2).toString());
                return;
            }
            if (!bl2) return;
            try {
                ((Dispatcher)((Object)string)).IdlingResourceRegistry.this.idleNotificationCallback.allResourcesIdle();
                return;
            }
            finally {
                super.deregister();
            }
        }

        private void handleTimeoutWarning() {
            List list = IdlingResourceRegistry.this.getBusyResources();
            if (list == null) {
                IdlingResourceRegistry.this.handler.sendMessage(IdlingResourceRegistry.this.handler.obtainMessage(3, TIMEOUT_MESSAGE_TAG));
                return;
            }
            IdlingPolicy idlingPolicy = IdlingPolicies.getDynamicIdlingResourceWarningPolicy();
            IdlingResourceRegistry.this.idleNotificationCallback.resourcesStillBusyWarning(list);
            IdlingResourceRegistry.this.handler.sendMessageDelayed(IdlingResourceRegistry.this.handler.obtainMessage(3, TIMEOUT_MESSAGE_TAG), idlingPolicy.getIdleTimeoutUnit().toMillis(idlingPolicy.getIdleTimeout()));
        }

        private void handleTimeout() {
            List list = IdlingResourceRegistry.this.getBusyResources();
            if (list == null) {
                IdlingResourceRegistry.this.handler.sendMessage(IdlingResourceRegistry.this.handler.obtainMessage(2, TIMEOUT_MESSAGE_TAG));
                return;
            }
            try {
                IdlingResourceRegistry.this.idleNotificationCallback.resourcesHaveTimedOut(list);
            }
            finally {
                this.deregister();
            }
        }

        private void handleRaceCondition(Message m) {
            Object object = ((List)m.obj).iterator();
            while (object.hasNext()) {
                IdlingState idlingState = (IdlingState)object.next();
                if (idlingState.idle) continue;
                Locale locale = Locale.ROOT;
                Object[] objectArray = new Object[]{idlingState.resource.getName()};
                object = new IllegalStateException(String.format(locale, "Resource %s isIdleNow() is returning true, but a message indicating that the resource has transitioned from busy to idle was never sent.", objectArray));
                throw object;
            }
        }

        private void deregister() {
            IdlingResourceRegistry.this.handler.removeCallbacksAndMessages(TIMEOUT_MESSAGE_TAG);
            IdlingResourceRegistry.access$602(IdlingResourceRegistry.this, NO_OP_CALLBACK);
        }
    }

    private static class IdlingState
    implements IdlingResource.ResourceCallback {
        final IdlingResource resource;
        final Handler handler;
        boolean idle;

        /*
         * WARNING - void declaration
         */
        private IdlingState(IdlingResource resource, Handler handler) {
            void var2_2;
            void var1_1;
            this.resource = var1_1;
            this.handler = var2_2;
        }

        private void registerSelf() {
            this.resource.registerIdleTransitionCallback((IdlingResource.ResourceCallback)this);
            this.idle = this.resource.isIdleNow();
        }

        public void onTransitionToIdle() {
            Message message = this.handler.obtainMessage(1);
            message.obj = this;
            this.handler.sendMessage(message);
        }
    }

    static interface IdleNotificationCallback {
        public void allResourcesIdle();

        public void resourcesStillBusyWarning(List<String> var1);

        public void resourcesHaveTimedOut(List<String> var1);
    }
}

