/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.EventInjectionStrategy;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class InputManagerEventInjectionStrategy
implements EventInjectionStrategy {
    private static final String TAG = "EventInjectionStrategy";
    private static final long KEYBOARD_DISMISSAL_DELAY_MILLIS = 1000L;
    private boolean initComplete;
    private Method injectInputEventMethod;
    private Method setSourceMotionMethod;
    private Object instanceInputManagerObject;
    private int asyncEventMode;
    private int syncEventMode;

    /*
     * Enabled aggressive block sorting
     */
    InputManagerEventInjectionStrategy() {
        boolean bl = Build.VERSION.SDK_INT >= 16;
        Preconditions.checkState(bl, "Unsupported API level.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void initialize() {
        Object object;
        if (this.initComplete) {
            return;
        }
        try {
            Log.d((String)TAG, (String)"Creating injection strategy with input manager.");
            object = Class.forName("android.hardware.input.InputManager");
            AnnotatedElement annotatedElement = ((Class)object).getDeclaredMethod("getInstance", new Class[0]);
            ((Method)annotatedElement).setAccessible(true);
            this.instanceInputManagerObject = ((Method)annotatedElement).invoke(object, new Object[0]);
            annotatedElement = this.instanceInputManagerObject.getClass();
            Class[] classArray = "injectInputEvent";
            Class[] classArray2 = new Class[]{InputEvent.class, Integer.TYPE};
            this.injectInputEventMethod = ((Class)annotatedElement).getDeclaredMethod((String)classArray, classArray2);
            this.injectInputEventMethod.setAccessible(true);
            annotatedElement = ((Class)object).getField("INJECT_INPUT_EVENT_MODE_WAIT_FOR_FINISH");
            ((Field)annotatedElement).setAccessible(true);
            this.syncEventMode = ((Field)annotatedElement).getInt(object);
            int n = Build.VERSION.SDK_INT;
            if (n >= 28) {
                this.asyncEventMode = 0;
            } else {
                Field field = ((Class)object).getField("INJECT_INPUT_EVENT_MODE_ASYNC");
                field.setAccessible(true);
                this.asyncEventMode = field.getInt(object);
            }
            object = MotionEvent.class;
            String string = "setSource";
            classArray = new Class[]{Integer.TYPE};
            this.setSourceMotionMethod = ((Class)object).getDeclaredMethod(string, classArray);
            this.initComplete = true;
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            object = new RuntimeException(noSuchFieldException);
            throw object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = new RuntimeException(classNotFoundException);
            throw object;
        }
        catch (IllegalAccessException illegalAccessException) {
            object = new RuntimeException(illegalAccessException);
            throw object;
        }
        catch (InvocationTargetException invocationTargetException) {
            object = new RuntimeException(invocationTargetException);
            throw object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object = new RuntimeException(noSuchMethodException);
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectKeyEvent(KeyEvent keyEvent) throws InjectEventSecurityException {
        Object object;
        block4: {
            try {
                Method method = this.injectInputEventMethod;
                Object object2 = this.instanceInputManagerObject;
                Object[] objectArray = new Object[]{object, this.syncEventMode};
                return (Boolean)method.invoke(object2, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                object = new RuntimeException(illegalAccessException);
                throw object;
            }
            catch (SecurityException securityException) {
                object = new InjectEventSecurityException(securityException);
                throw object;
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException.getCause();
                if (object instanceof SecurityException) break block4;
            }
            object = new RuntimeException(invocationTargetException);
            throw object;
        }
        InjectEventSecurityException injectEventSecurityException = new InjectEventSecurityException((Throwable)object);
        throw injectEventSecurityException;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean injectMotionEvent(MotionEvent motionEvent, boolean sync) throws InjectEventSecurityException {
        void var2_2;
        void var1_1;
        return this.innerInjectMotionEvent((MotionEvent)var1_1, true, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean innerInjectMotionEvent(MotionEvent motionEvent, boolean shouldRetry, boolean sync) throws InjectEventSecurityException {
        void var3_6;
        Object object;
        block10: {
            Object object2;
            InvocationTargetException invocationTargetException2;
            block9: {
                try {
                    void var4_11;
                    Object[] objectArray;
                    boolean bl;
                    int n = motionEvent.getSource();
                    if ((n & 2) == 0 && !(bl = InputManagerEventInjectionStrategy.isFromTouchpadInGlassDevice((MotionEvent)object))) {
                        Method method = ((InputManagerEventInjectionStrategy)object2).setSourceMotionMethod;
                        objectArray = new Object[]{4098};
                        method.invoke(object, objectArray);
                    }
                    if (var3_6 != false) {
                        int n2 = ((InputManagerEventInjectionStrategy)object2).syncEventMode;
                    } else {
                        int n3 = ((InputManagerEventInjectionStrategy)object2).asyncEventMode;
                    }
                    objectArray = ((InputManagerEventInjectionStrategy)object2).injectInputEventMethod;
                    Object object3 = ((InputManagerEventInjectionStrategy)object2).instanceInputManagerObject;
                    Object[] objectArray2 = new Object[]{object, (int)var4_11};
                    return (Boolean)objectArray.invoke(object3, objectArray2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    object = new RuntimeException(illegalAccessException);
                    throw object;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw illegalArgumentException;
                }
                catch (InvocationTargetException invocationTargetException2) {
                    void var2_5;
                    Throwable throwable = invocationTargetException2.getCause();
                    if (!(throwable instanceof SecurityException)) break block9;
                    if (var2_5 == false) {
                        object2 = new InjectEventSecurityException(throwable);
                        throw object2;
                    }
                    break block10;
                }
                catch (SecurityException securityException) {
                    object = new InjectEventSecurityException(securityException);
                    throw object;
                }
            }
            object2 = new RuntimeException(invocationTargetException2);
            throw object2;
        }
        Log.w((String)TAG, (String)"Error performing a ViewAction! soft keyboard dismissal animation may have been in the way. Retrying once after: 1000 millis");
        SystemClock.sleep((long)1000L);
        super.innerInjectMotionEvent((MotionEvent)object, false, (boolean)var3_6);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isFromTouchpadInGlassDevice(MotionEvent motionEvent) {
        MotionEvent motionEvent2;
        if (!Build.DEVICE.contains("glass") && !Build.DEVICE.contains("Glass")) {
            if (!Build.DEVICE.contains("wingman")) return false;
        }
        if ((motionEvent2.getSource() & 0x100008) == 0) return false;
        return true;
    }
}

