/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Binder;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class Interrogator {
    private static final String TAG = "Interrogator";
    private static final Method messageQueueNextMethod;
    private static final Field messageQueueHeadField;
    private static final Method recycleUncheckedMethod;
    private static final int LOOKAHEAD_MILLIS = 15;
    private static final ThreadLocal<Boolean> interrogating;

    Interrogator() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <R> R loopAndInterrogate(InterrogationHandler<R> handler) {
        Interrogator.checkSanity();
        interrogating.set(Boolean.TRUE);
        MessageQueue messageQueue = Looper.myQueue();
        long l = Binder.clearCallingIdentity();
        try {
            InterrogationHandler<R> interrogationHandler;
            long l2 = Binder.clearCallingIdentity();
            boolean bl = true;
            while (bl) {
                bl = Interrogator.interrogateQueueState(messageQueue, interrogationHandler);
                if (!bl) continue;
                Message message = Interrogator.getNextMessage();
                if (message == null) {
                    interrogationHandler.quitting();
                    Object r = interrogationHandler.get();
                    return r;
                }
                boolean bl2 = interrogationHandler.beforeTaskDispatch();
                interrogationHandler.setMessage(message);
                message.getTarget().dispatchMessage(message);
                long l3 = Binder.clearCallingIdentity();
                if (l3 != l2) {
                    String string = TAG;
                    String string2 = Long.toHexString(l2);
                    String string3 = Long.toHexString(l3);
                    String string4 = message.getTarget().getClass().getName();
                    String string5 = String.valueOf(message.getCallback());
                    int n = message.what;
                    int n2 = String.valueOf(string2).length();
                    n2 += 77;
                    int n3 = String.valueOf(string3).length();
                    n2 += n3;
                    n3 = String.valueOf(string4).length();
                    n2 += n3;
                    n3 = String.valueOf(string5).length();
                    StringBuilder stringBuilder = new StringBuilder(n2 += n3);
                    Log.wtf((String)string, (String)stringBuilder.append("Thread identity changed from 0x").append(string2).append(" to 0x").append(string3).append(" while dispatching to ").append(string4).append(" ").append(string5).append(" what=").append(n).toString());
                }
                Interrogator.recycle(message);
                bl = bl2;
            }
            return interrogationHandler.get();
        }
        finally {
            Binder.restoreCallingIdentity((long)l);
            interrogating.set(Boolean.FALSE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void recycle(Message m) {
        InvocationTargetException invocationTargetException2;
        block4: {
            Message message;
            if (recycleUncheckedMethod == null) {
                message.recycle();
                return;
            }
            try {
                recycleUncheckedMethod.invoke((Object)message, new Object[0]);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                Throwables.throwIfUnchecked(exception);
                RuntimeException runtimeException = new RuntimeException(exception);
                throw runtimeException;
            }
            catch (InvocationTargetException invocationTargetException2) {
                if (invocationTargetException2.getCause() != null) break block4;
            }
            RuntimeException runtimeException = new RuntimeException(invocationTargetException2);
            throw runtimeException;
        }
        Throwables.throwIfUnchecked(invocationTargetException2.getCause());
        RuntimeException runtimeException = new RuntimeException(invocationTargetException2.getCause());
        throw runtimeException;
    }

    private static Message getNextMessage() {
        Message message;
        try {
            message = (Message)messageQueueNextMethod.invoke((Object)Looper.myQueue(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            Throwables.throwIfUnchecked(exception);
            RuntimeException runtimeException = new RuntimeException(exception);
            throw runtimeException;
        }
        return message;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static <R> R peekAtQueueState(MessageQueue q, QueueInterrogationHandler<R> handler) {
        MessageQueue messageQueue;
        void var1_2;
        Preconditions.checkNotNull(q);
        Preconditions.checkNotNull(var1_2);
        boolean bl = !Interrogator.interrogateQueueState(messageQueue, var1_2);
        Preconditions.checkState(bl, "It is expected that %s would stop interrogation after a single peak at the queue.", var1_2);
        return var1_2.get();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean interrogateQueueState(MessageQueue q, QueueInterrogationHandler<?> handler) {
        synchronized (q) {
            void var1_1;
            Message message;
            try {
                MessageQueue messageQueue;
                message = (Message)messageQueueHeadField.get(messageQueue);
                if (message == null) {
                    return var1_1.queueEmpty();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                RuntimeException runtimeException = new RuntimeException(illegalAccessException);
                throw runtimeException;
            }
            Object object = message.getTarget();
            if (object == null) {
                boolean bl = Log.isLoggable((String)TAG, (int)3);
                if (!bl) return var1_1.barrierUp();
                Log.d((String)TAG, (String)"barrier is up");
                return var1_1.barrierUp();
            }
            long l = message.getWhen();
            long l2 = SystemClock.uptimeMillis();
            long l3 = l2 + 15L;
            boolean bl = Log.isLoggable((String)TAG, (int)3);
            if (bl) {
                object = TAG;
                bl = l3 < l;
                StringBuilder stringBuilder = new StringBuilder(75);
                Log.d((String)object, (String)stringBuilder.append("headWhen: ").append(l).append(" nowFuz: ").append(l3).append(" due long: ").append(bl).toString());
            }
            if (l3 <= l) return var1_1.taskDueLong();
            return var1_1.taskDueSoon();
            {
                catch (Throwable throwable) {}
                {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void checkSanity() {
        boolean bl = Looper.myLooper() != null;
        Preconditions.checkState(bl, "Calling non-looper thread!");
        Preconditions.checkState(Boolean.FALSE.equals(interrogating.get()), "Already interrogating!");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        ThreadLocal<Boolean> threadLocal;
        block6: {
            threadLocal = new ThreadLocal<Boolean>(){

                @Override
                public Boolean initialValue() {
                    return Boolean.FALSE;
                }
            };
            interrogating = threadLocal;
            messageQueueNextMethod = MessageQueue.class.getDeclaredMethod("next", new Class[0]);
            messageQueueNextMethod.setAccessible(true);
            messageQueueHeadField = MessageQueue.class.getDeclaredField("mMessages");
            messageQueueHeadField.setAccessible(true);
            threadLocal = Message.class.getDeclaredMethod("recycleUnchecked", new Class[0]);
            try {
                ((Method)((Object)threadLocal)).setAccessible(true);
                break block6;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            catch (IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
                Log.e((String)TAG, (String)"Could not initialize interrogator!", (Throwable)exception);
                RuntimeException runtimeException = new RuntimeException("Could not initialize interrogator!", exception);
                throw runtimeException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                threadLocal = null;
            }
        }
        recycleUncheckedMethod = threadLocal;
    }

    static interface InterrogationHandler<R>
    extends QueueInterrogationHandler<R> {
        public boolean beforeTaskDispatch();

        public void quitting();

        public void setMessage(Message var1);

        public String getMessage();
    }

    static interface QueueInterrogationHandler<R> {
        public boolean queueEmpty();

        public boolean taskDueSoon();

        public boolean taskDueLong();

        public boolean barrierUp();

        public R get();
    }
}

