/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.app.Activity;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.NoMatchingRootException;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.base.RootViewPickerScope;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.internal.util.LogUtil;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.Stage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Provider;
import org.hamcrest.Matcher;

@RootViewPickerScope
public final class RootViewPicker
implements Provider<View> {
    private static final String TAG = RootViewPicker.class.getSimpleName();
    private static final ImmutableList<Integer> CREATED_WAIT_TIMES = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(50), Integer.valueOf(150), Integer.valueOf(250));
    private static final ImmutableList<Integer> RESUMED_WAIT_TIMES = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(50), Integer.valueOf(100), Integer.valueOf(500), Integer.valueOf(2000), Integer.valueOf(30000));
    private final UiController uiController;
    private final ActivityLifecycleMonitor activityLifecycleMonitor;
    private final AtomicReference<Boolean> needsActivity;
    private final RootResultFetcher rootResultFetcher;
    private final ControlledLooper controlledLooper;

    /*
     * WARNING - void declaration
     */
    RootViewPicker(UiController uiController, RootResultFetcher rootResultFetcher, ActivityLifecycleMonitor activityLifecycleMonitor, AtomicReference<Boolean> needsActivity, ControlledLooper controlledLooper) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.uiController = var1_1;
        this.rootResultFetcher = var2_2;
        this.activityLifecycleMonitor = var3_3;
        this.needsActivity = var4_4;
        this.controlledLooper = var5_5;
    }

    public View get() {
        Preconditions.checkState(Looper.getMainLooper().equals(Looper.myLooper()), "must be called on main thread.");
        if (this.needsActivity.get().booleanValue()) {
            this.waitForAtLeastOneActivityToBeResumed();
        }
        return this.pickRootView();
    }

    /*
     * WARNING - void declaration
     */
    private Root waitForRootToBeReady(Root pickedRoot) {
        long l = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        Object object = new RootReadyBackoff();
        while (true) {
            void var1_1;
            if (System.currentTimeMillis() <= l) {
                if (var1_1.isReady()) {
                    return var1_1;
                }
            } else {
                object = Locale.ROOT;
                Object[] objectArray = new Object[]{var1_1};
                Object object2 = new RootViewWithoutFocusException(String.format((Locale)object, "Waited for the root of the view hierarchy to have window focus and not request layout for 10 seconds. If you specified a non default root matcher, it may be picking a root that never takes focus. Root:\n%s", objectArray));
                throw object2;
            }
            ((RootViewPicker)object2).controlledLooper.simulateWindowFocus(var1_1.getDecorView());
            ((RootViewPicker)object2).uiController.loopMainThreadForAtLeast(((BackOff)object).getNextBackoffInMillis());
        }
    }

    /*
     * Unable to fully structure code
     */
    private Root pickARoot() {
        var2_1 = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L);
        var1_2 = this.rootResultFetcher.fetch();
        var4_3 = new NoActiveRootsBackoff();
        var5_4 = new NoMatchingRootBackoff();
        block5: while (System.currentTimeMillis() <= var2_1) {
            switch (1.$SwitchMap$androidx$test$espresso$base$RootViewPicker$RootResults$State[var1_2.getState().ordinal()]) lbl-1000:
            // 3 sources

            {
                default: {
                    var1_2 = this.rootResultFetcher.fetch();
                    continue block5;
                }
                case 3: {
                    this.uiController.loopMainThreadForAtLeast(var5_4.getNextBackoffInMillis());
                    ** GOTO lbl-1000
                }
                case 2: {
                    this.uiController.loopMainThreadForAtLeast(var4_3.getNextBackoffInMillis());
                    ** GOTO lbl-1000
                }
                case 1: 
            }
            return var1_2.getPickedRoot();
        }
        if (RootResults.State.ROOTS_PICKED != var1_2.getState()) {
            throw NoMatchingRootException.create((Matcher<Root>)RootResults.access$100(var1_2), RootResults.access$200(var1_2));
        }
        return var1_2.getPickedRoot();
    }

    private View pickRootView() {
        return this.waitForRootToBeReady(this.pickARoot()).getDecorView();
    }

    private void waitForAtLeastOneActivityToBeResumed() {
        Object this_;
        List<Activity> list = ((RootViewPicker)this_).activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED);
        if (list.isEmpty()) {
            ((RootViewPicker)this_).uiController.loopMainThreadUntilIdle();
            list = ((RootViewPicker)this_).activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED);
        }
        if (list.isEmpty()) {
            StringBuilder stringBuilder;
            long l;
            Object object;
            list = ((RootViewPicker)this_).getAllActiveActivities();
            if (list.isEmpty()) {
                object = CREATED_WAIT_TIMES.iterator();
                while (object.hasNext()) {
                    l = ((Integer)object.next()).intValue();
                    list = TAG;
                    stringBuilder = new StringBuilder(72);
                    Log.w((String)((Object)list), (String)stringBuilder.append("No activities found - waiting: ").append(l).append("ms for one to appear.").toString());
                    ((RootViewPicker)this_).uiController.loopMainThreadForAtLeast(l);
                    list = super.getAllActiveActivities();
                    if (list.isEmpty()) continue;
                }
            }
            if (list.isEmpty()) {
                this_ = new NoActivityResumedException("No activities found. Did you forget to launch the activity by calling getActivity() or startActivitySync or similar?");
                throw this_;
            }
            list = RESUMED_WAIT_TIMES.iterator();
            while (list.hasNext()) {
                l = ((Integer)list.next()).intValue();
                object = TAG;
                stringBuilder = new StringBuilder(82);
                Log.w((String)object, (String)stringBuilder.append("No activity currently resumed - waiting: ").append(l).append("ms for one to appear.").toString());
                ((RootViewPicker)this_).uiController.loopMainThreadForAtLeast(l);
                if (((RootViewPicker)this_).activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED).isEmpty()) continue;
                return;
            }
        } else {
            return;
        }
        this_ = new NoActivityResumedException("No activities in stage RESUMED. Did you forget to launch the activity. (test.getActivity() or similar)?");
        throw this_;
    }

    private List<Activity> getAllActiveActivities() {
        ArrayList<Activity> arrayList = Lists.newArrayList();
        for (Object e : EnumSet.range(Stage.PRE_ON_CREATE, Stage.RESTARTED)) {
            Stage object = (Stage)e;
            arrayList.addAll(this.activityLifecycleMonitor.getActivitiesInStage(object));
        }
        return arrayList;
    }

    private static final class RootViewWithoutFocusException
    extends RuntimeException
    implements EspressoException {
        /*
         * WARNING - void declaration
         */
        private RootViewWithoutFocusException(String message) {
            super((String)var1_1);
            void var1_1;
        }
    }

    private static final class RootReadyBackoff
    extends BackOff {
        private static final ImmutableList<Integer> ROOT_READY_BACKOFF = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(25), Integer.valueOf(50), Integer.valueOf(100), Integer.valueOf(200), Integer.valueOf(400), Integer.valueOf(800), Integer.valueOf(1000));

        public RootReadyBackoff() {
            super(ROOT_READY_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long l = ((BackOff)((Object)this_)).getBackoffForAttempt();
            String this_ = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{l};
            Log.d((String)this_, (String)String.format(locale, "Root not ready - waiting: %sms for one to appear.", objectArray));
            return l;
        }
    }

    private static final class NoMatchingRootBackoff
    extends BackOff {
        private static final ImmutableList<Integer> NO_MATCHING_ROOT_BACKOFF = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(20), Integer.valueOf(200), Integer.valueOf(400), Integer.valueOf(1000), Integer.valueOf(2000));

        public NoMatchingRootBackoff() {
            super(NO_MATCHING_ROOT_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long l = ((BackOff)((Object)this_)).getBackoffForAttempt();
            String this_ = TAG;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{l};
            Log.d((String)this_, (String)String.format(locale, "No matching root available - waiting: %sms for one to appear.", objectArray));
            return l;
        }
    }

    private static final class NoActiveRootsBackoff
    extends BackOff {
        private static final ImmutableList<Integer> NO_ACTIVE_ROOTS_BACKOFF = ImmutableList.of(Integer.valueOf(10), Integer.valueOf(10), Integer.valueOf(20), Integer.valueOf(30), Integer.valueOf(50), Integer.valueOf(80), Integer.valueOf(130), Integer.valueOf(210), Integer.valueOf(340));

        public NoActiveRootsBackoff() {
            super(NO_ACTIVE_ROOTS_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long l = ((BackOff)((Object)this_)).getBackoffForAttempt();
            String this_ = TAG;
            Object[] objectArray = new Object[]{l};
            LogUtil.logDebugWithProcess((String)this_, (String)"No active roots available - waiting: %sms for one to appear.", (Object[])objectArray);
            return l;
        }
    }

    private static abstract class BackOff {
        private final List<Integer> backoffTimes;
        private final TimeUnit timeUnit;
        private int numberOfAttempts = 0;

        /*
         * WARNING - void declaration
         */
        public BackOff(List<Integer> backoffTimes, TimeUnit timeUnit) {
            void var2_2;
            void var1_1;
            this.backoffTimes = var1_1;
            this.timeUnit = var2_2;
        }

        protected abstract long getNextBackoffInMillis();

        protected final long getBackoffForAttempt() {
            if (this.numberOfAttempts >= this.backoffTimes.size()) {
                return this.backoffTimes.get(this.backoffTimes.size() + -1).intValue();
            }
            Object object = this.backoffTimes;
            int n = this.numberOfAttempts++;
            object = object.get(n);
            object = (Integer)object;
            int n2 = (Integer)object;
            return this.timeUnit.toMillis(n2);
        }
    }

    static class RootResultFetcher {
        private final Matcher<Root> selector;
        private final ActiveRootLister activeRootLister;

        /*
         * WARNING - void declaration
         */
        public RootResultFetcher(ActiveRootLister activeRootLister, AtomicReference<Matcher<Root>> rootMatcherRef) {
            void var2_2;
            void var1_1;
            this.activeRootLister = var1_1;
            this.selector = (Matcher)var2_2.get();
        }

        public RootResults fetch() {
            List<Root> list = this.activeRootLister.listActiveRoots();
            ArrayList<Root> arrayList = Lists.newArrayList();
            for (Root root : list) {
                if (!this.selector.matches((Object)root)) continue;
                arrayList.add(root);
            }
            Object object = new RootResults(list, arrayList, this.selector);
            return object;
        }
    }

    private static class RootResults {
        private final List<Root> allRoots;
        private final List<Root> pickedRoots;
        private final Matcher<Root> rootSelector;

        /*
         * WARNING - void declaration
         */
        private RootResults(List<Root> allRoots, List<Root> pickedRoots, Matcher<Root> rootSelector) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.allRoots = var1_1;
            this.pickedRoots = var2_2;
            this.rootSelector = var3_3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isTopmostRoot(Root topMostRoot, Root root) {
            Root root2;
            if (root.getWindowLayoutParams().get().type <= root2.getWindowLayoutParams().get().type) return false;
            return true;
        }

        public State getState() {
            if (this.allRoots.isEmpty()) {
                return State.NO_ROOTS_PRESENT;
            }
            if (this.pickedRoots.isEmpty()) {
                return State.NO_ROOTS_PICKED;
            }
            if (this.pickedRoots.size() > 0) {
                return State.ROOTS_PICKED;
            }
            return State.NO_ROOTS_PICKED;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Root getRootFromMultipleRoots() {
            Root root = ((RootResults)this_).pickedRoots.get(0);
            if (((RootResults)this_).pickedRoots.size() <= 0) return root;
            Iterator<Root> iterator = ((RootResults)this_).pickedRoots.iterator();
            Object this_ = root;
            while (iterator.hasNext()) {
                root = iterator.next();
                if (RootMatchers.isDialog().matches((Object)root)) {
                    return root;
                }
                if (!RootResults.isTopmostRoot((Root)this_, root)) continue;
                this_ = root;
            }
            return this_;
        }

        public Root getPickedRoot() {
            if (this.pickedRoots.size() > 1) {
                String string = TAG;
                Object[] objectArray = new Object[]{this.pickedRoots};
                LogUtil.logDebugWithProcess((String)string, (String)"Multiple root windows detected: %s", (Object[])objectArray);
                return this.getRootFromMultipleRoots();
            }
            return this.pickedRoots.get(0);
        }

        static /* synthetic */ Matcher access$100(RootResults x0) {
            return x0.rootSelector;
        }

        static /* synthetic */ List access$200(RootResults x0) {
            return x0.allRoots;
        }

        static final class State
        extends Enum<State> {
            public static final /* enum */ State NO_ROOTS_PRESENT;
            public static final /* enum */ State NO_ROOTS_PICKED;
            public static final /* enum */ State ROOTS_PICKED;
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String name) {
                String string;
                return Enum.valueOf(State.class, string);
            }

            static {
                State state;
                NO_ROOTS_PRESENT = state = new State();
                NO_ROOTS_PICKED = state = new State();
                ROOTS_PICKED = state = new State();
                $VALUES = stateArray = new State[]{State.NO_ROOTS_PRESENT, State.NO_ROOTS_PICKED, State.ROOTS_PICKED};
            }
        }
    }
}

