/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Range;
import androidx.test.espresso.core.internal.deps.guava.primitives.Booleans;
import java.io.Serializable;

abstract class Cut<C extends Comparable>
implements Comparable<Cut<C>>,
Serializable {
    final C endpoint;
    private static final long serialVersionUID = 0L;

    Cut(C c) {
        this.endpoint = c;
    }

    abstract boolean isLessThan(C var1);

    abstract void describeAsLowerBound(StringBuilder var1);

    abstract void describeAsUpperBound(StringBuilder var1);

    @Override
    public int compareTo(Cut<C> cut) {
        if (cut == Cut.belowAll()) {
            return 1;
        }
        if (cut == Cut.aboveAll()) {
            return -1;
        }
        int n = Range.compareOrThrow(this.endpoint, cut.endpoint);
        if (n != 0) {
            return n;
        }
        return Booleans.compare(this instanceof AboveValue, cut instanceof AboveValue);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        Cut cut;
        if (!(cut instanceof Cut)) return false;
        cut = cut;
        try {
            void var0_3;
            int n = this.compareTo(cut);
            if (n != 0) return (boolean)var0_3;
            return (boolean)var0_3;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public abstract int hashCode();

    static <C extends Comparable> Cut<C> belowAll() {
        return BelowAll.INSTANCE;
    }

    static <C extends Comparable> Cut<C> aboveAll() {
        return AboveAll.INSTANCE;
    }

    static <C extends Comparable> Cut<C> belowValue(C c) {
        BelowValue<C> belowValue = new BelowValue<C>(c);
        return belowValue;
    }

    static <C extends Comparable> Cut<C> aboveValue(C c) {
        AboveValue<C> aboveValue = new AboveValue<C>(c);
        return aboveValue;
    }

    private static final class AboveValue<C extends Comparable>
    extends Cut<C> {
        private static final long serialVersionUID = 0L;

        AboveValue(C c) {
            super((Comparable)Preconditions.checkNotNull(c));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean isLessThan(C c) {
            if (Range.compareOrThrow(this.endpoint, c) >= 0) return false;
            return true;
        }

        @Override
        void describeAsLowerBound(StringBuilder stringBuilder) {
            stringBuilder.append('(').append(this.endpoint);
        }

        @Override
        void describeAsUpperBound(StringBuilder stringBuilder) {
            stringBuilder.append(this.endpoint).append(']');
        }

        @Override
        public int hashCode() {
            return ~this.endpoint.hashCode();
        }

        public String toString() {
            String string = String.valueOf(((AboveValue)((Object)string)).endpoint);
            String string2 = String.valueOf(string);
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 2);
            return stringBuilder.append("/").append(string).append("\\").toString();
        }
    }

    private static final class BelowValue<C extends Comparable>
    extends Cut<C> {
        private static final long serialVersionUID = 0L;

        BelowValue(C c) {
            super((Comparable)Preconditions.checkNotNull(c));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean isLessThan(C c) {
            if (Range.compareOrThrow(this.endpoint, c) > 0) return false;
            return true;
        }

        @Override
        void describeAsLowerBound(StringBuilder stringBuilder) {
            stringBuilder.append('[').append(this.endpoint);
        }

        @Override
        void describeAsUpperBound(StringBuilder stringBuilder) {
            stringBuilder.append(this.endpoint).append(')');
        }

        @Override
        public int hashCode() {
            return this.endpoint.hashCode();
        }

        public String toString() {
            String string = String.valueOf(((BelowValue)((Object)string)).endpoint);
            String string2 = String.valueOf(string);
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 2);
            return stringBuilder.append("\\").append(string).append("/").toString();
        }
    }

    private static final class AboveAll
    extends Cut<Comparable<?>> {
        private static final AboveAll INSTANCE;
        private static final long serialVersionUID = 0L;

        private AboveAll() {
            super(null);
        }

        @Override
        boolean isLessThan(Comparable<?> comparable) {
            return false;
        }

        @Override
        void describeAsLowerBound(StringBuilder stringBuilder) {
            Object object = new AssertionError();
            throw object;
        }

        @Override
        void describeAsUpperBound(StringBuilder stringBuilder) {
            stringBuilder.append("+\u221e)");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(Cut<Comparable<?>> cut) {
            if (cut != this) return 1;
            return 0;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        public String toString() {
            return "+\u221e";
        }

        private Object readResolve() {
            return INSTANCE;
        }

        static {
            AboveAll aboveAll;
            INSTANCE = aboveAll = new AboveAll();
        }
    }

    private static final class BelowAll
    extends Cut<Comparable<?>> {
        private static final BelowAll INSTANCE;
        private static final long serialVersionUID = 0L;

        private BelowAll() {
            super(null);
        }

        @Override
        boolean isLessThan(Comparable<?> comparable) {
            return true;
        }

        @Override
        void describeAsLowerBound(StringBuilder stringBuilder) {
            stringBuilder.append("(-\u221e");
        }

        @Override
        void describeAsUpperBound(StringBuilder stringBuilder) {
            Object object = new AssertionError();
            throw object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(Cut<Comparable<?>> cut) {
            if (cut != this) return -1;
            return 0;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        public String toString() {
            return "-\u221e";
        }

        private Object readResolve() {
            return INSTANCE;
        }

        static {
            BelowAll belowAll;
            INSTANCE = belowAll = new BelowAll();
        }
    }
}

