/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.AbstractIndexedListIterator;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableCollection;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.collect.ObjectArrays;
import androidx.test.espresso.core.internal.deps.guava.collect.RegularImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableIterator;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableListIterator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    private static final UnmodifiableListIterator<Object> EMPTY_ITR;

    public static <E> ImmutableList<E> of() {
        return RegularImmutableList.EMPTY;
    }

    public static <E> ImmutableList<E> of(E e) {
        Object[] objectArray = new Object[]{e};
        return ImmutableList.construct(objectArray);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4) {
        Object[] objectArray = new Object[]{e, e2, e3, e4};
        return ImmutableList.construct(objectArray);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6) {
        Object[] objectArray = new Object[]{e, e2, e3, e4, e5, e6};
        return ImmutableList.construct(objectArray);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7, E e8) {
        Object[] objectArray = new Object[]{e, e2, e3, e4, e5, e6, e7, e8};
        return ImmutableList.construct(objectArray);
    }

    public static <E> ImmutableList<E> of(E e, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9) {
        Object[] objectArray = new Object[]{e, e2, e3, e4, e5, e6, e7, e8, e9};
        return ImmutableList.construct(objectArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <E> ImmutableList<E> copyOf(E[] object) {
        void var0_2;
        if (((Object)object).length == 0) {
            ImmutableList<E> immutableList = ImmutableList.of();
            return var0_2;
        }
        ImmutableList<E> immutableList = ImmutableList.construct((Object[])object.clone());
        return var0_2;
    }

    private static <E> ImmutableList<E> construct(Object ... objectArray) {
        return ImmutableList.asImmutableList(ObjectArrays.checkElementsNotNull(objectArray));
    }

    static <E> ImmutableList<E> asImmutableList(Object[] objectArray) {
        return ImmutableList.asImmutableList(objectArray, objectArray.length);
    }

    static <E> ImmutableList<E> asImmutableList(Object[] objectArray, int n) {
        if (n == 0) {
            return ImmutableList.of();
        }
        RegularImmutableList regularImmutableList = new RegularImmutableList(objectArray, n);
        return regularImmutableList;
    }

    ImmutableList() {
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public UnmodifiableListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int n) {
        Preconditions.checkPositionIndex(n, this.size());
        if (this.isEmpty()) {
            return EMPTY_ITR;
        }
        Itr itr = new Itr(this, n);
        return itr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int indexOf(Object object) {
        if (object != null) return Lists.indexOfImpl(this, object);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int lastIndexOf(Object object) {
        if (object != null) return Lists.lastIndexOfImpl(this, object);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(Object object) {
        if (this.indexOf(object) < 0) return false;
        return true;
    }

    @Override
    public ImmutableList<E> subList(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.size());
        int n3 = n2 - n;
        if (n3 == this.size()) {
            return this;
        }
        if (n3 == 0) {
            return ImmutableList.of();
        }
        return this.subListUnchecked(n, n2);
    }

    ImmutableList<E> subListUnchecked(int n, int n2) {
        SubList subList = new SubList(n, n2 - n);
        return subList;
    }

    @Override
    @Deprecated
    public final boolean addAll(int n, Collection<? extends E> collection) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final E set(int n, E e) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final void add(int n, E e) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    @Deprecated
    public final E remove(int n) {
        Serializable serializable = new UnsupportedOperationException();
        throw serializable;
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            objectArray[n + i] = this.get(i);
        }
        return n + n2;
    }

    @Override
    public boolean equals(Object object) {
        return Lists.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        int n = this.size();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + this.get(i).hashCode();
        }
        return n2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        Serializable serializable = new InvalidObjectException("Use SerializedForm");
        throw serializable;
    }

    @Override
    Object writeReplace() {
        SerializedForm serializedForm = new SerializedForm(this.toArray());
        return serializedForm;
    }

    public static <E> Builder<E> builder() {
        Builder builder = new Builder();
        return builder;
    }

    static {
        Itr<Object> itr = new Itr<Object>(RegularImmutableList.EMPTY, 0);
        EMPTY_ITR = itr;
    }

    public static final class Builder<E>
    extends ImmutableCollection.ArrayBasedBuilder<E> {
        public Builder() {
            this(4);
        }

        Builder(int n) {
            super(n);
        }

        @Override
        public Builder<E> add(E e) {
            super.add(e);
            return this;
        }

        public ImmutableList<E> build() {
            this.forceCopy = true;
            return ImmutableList.asImmutableList(this.contents, this.size);
        }
    }

    static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableList.copyOf(this.elements);
        }
    }

    class SubList
    extends ImmutableList<E> {
        final transient int offset;
        final transient int length;

        SubList(int n, int n2) {
            this.offset = n;
            this.length = n2;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        Object[] internalArray() {
            return ImmutableList.this.internalArray();
        }

        @Override
        int internalArrayStart() {
            return ImmutableList.this.internalArrayStart() + this.offset;
        }

        @Override
        int internalArrayEnd() {
            return ImmutableList.this.internalArrayStart() + this.offset + this.length;
        }

        @Override
        public E get(int n) {
            Preconditions.checkElementIndex(n, this.length);
            return ImmutableList.this.get(n + this.offset);
        }

        @Override
        public ImmutableList<E> subList(int n, int n2) {
            Preconditions.checkPositionIndexes(n, n2, this.length);
            return ImmutableList.this.subList(n + this.offset, n2 + this.offset);
        }
    }

    static class Itr<E>
    extends AbstractIndexedListIterator<E> {
        private final ImmutableList<E> list;

        Itr(ImmutableList<E> immutableList, int n) {
            super(immutableList.size(), n);
            this.list = immutableList;
        }

        @Override
        protected E get(int n) {
            return this.list.get(n);
        }
    }
}

