/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.FluentIterable;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.collect.ObjectArrays;
import java.util.Collection;
import java.util.Iterator;

public final class Iterables {
    public static String toString(Iterable<?> iterable) {
        return Iterators.toString(iterable.iterator());
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> clazz) {
        return Iterables.toArray(iterable, ObjectArrays.newArray(clazz, 0));
    }

    static <T> T[] toArray(Iterable<? extends T> iterable, T[] TArray) {
        return Iterables.castOrCopyToCollection(iterable).toArray(TArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <E> Collection<E> castOrCopyToCollection(Iterable<E> collection) {
        if (!(collection instanceof Collection)) return Lists.newArrayList(collection.iterator());
        return collection;
    }

    public static <T> Iterable<T> filter(final Iterable<T> iterable, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(predicate);
        FluentIterable fluentIterable = new FluentIterable(){

            @Override
            public Iterator iterator() {
                return Iterators.filter(iterable.iterator(), predicate);
            }
        };
        return fluentIterable;
    }

    public static <F, T> Iterable<T> transform(final Iterable<F> iterable, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(function);
        FluentIterable fluentIterable = new FluentIterable(){

            @Override
            public Iterator iterator() {
                return Iterators.transform(iterable.iterator(), function);
            }
        };
        return fluentIterable;
    }

    public static <T> T getFirst(Iterable<? extends T> iterable, T t) {
        return Iterators.getNext(iterable.iterator(), t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        if (iterable.iterator().hasNext()) return false;
        return true;
    }
}

