/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Objects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.AbstractIterator;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.collect.TransformedIterator;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Iterators {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean elementsEqual(Iterator<?> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (Objects.equal(iterator.next(), iterator2.next())) continue;
            return false;
        }
        if (iterator2.hasNext()) return false;
        return true;
    }

    public static String toString(Iterator<?> iterator) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append('[');
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuilder2.append(", ");
            }
            stringBuilder2.append(iterator.next());
            bl = false;
        }
        return stringBuilder2.append(']').toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> T getOnlyElement(Iterator<T> object) {
        Object e = object.next();
        if (!object.hasNext()) {
            return (T)e;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder = stringBuilder.append("expected one element but was: <").append(e);
        for (int i = 0; i < 4 && object.hasNext(); ++i) {
            stringBuilder.append(", ").append(object.next());
        }
        if (object.hasNext()) {
            stringBuilder.append(", ...");
        }
        stringBuilder.append('>');
        object = new IllegalArgumentException(stringBuilder.toString());
        throw object;
    }

    public static <T> T[] toArray(Iterator<? extends T> iterator, Class<T> clazz) {
        return Iterables.toArray(Lists.newArrayList(iterator), clazz);
    }

    public static <T> boolean addAll(Collection<T> collection, Iterator<? extends T> iterator) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(iterator);
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= collection.add(iterator.next());
        }
        return bl;
    }

    public static <T> UnmodifiableIterator<T> filter(final Iterator<T> iterator, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        AbstractIterator abstractIterator = new AbstractIterator(){

            protected Object computeNext() {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!predicate.apply(e)) continue;
                    return e;
                }
                return this.endOfData();
            }
        };
        return abstractIterator;
    }

    public static <F, T> Iterator<T> transform(Iterator<F> iterator, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(function);
        TransformedIterator transformedIterator = new TransformedIterator(iterator){

            Object transform(Object object) {
                return function.apply(object);
            }
        };
        return transformedIterator;
    }

    public static <T> T getNext(Iterator<? extends T> iterator, T t) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return t;
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(final T t) {
        UnmodifiableIterator unmodifiableIterator = new UnmodifiableIterator(){
            boolean done;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean hasNext() {
                if (this.done) return false;
                return true;
            }

            @Override
            public Object next() {
                if (object.done) {
                    Object object = new NoSuchElementException();
                    throw object;
                }
                object.done = true;
                return object.t;
            }
        };
        return unmodifiableIterator;
    }
}

