/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractListeningExecutorService;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.DirectExecutor;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ForwardingListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableScheduledFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListeningExecutorService;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.TrustedListenableFutureTask;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class MoreExecutors {
    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ListeningExecutorService listeningDecorator(ExecutorService executorService) {
        if (executorService instanceof ListeningExecutorService) {
            return (ListeningExecutorService)executorService;
        }
        if (executorService instanceof ScheduledExecutorService) {
            ScheduledListeningDecorator scheduledListeningDecorator = new ScheduledListeningDecorator((ScheduledExecutorService)executorService);
            return scheduledListeningDecorator;
        }
        ListeningDecorator listeningDecorator = new ListeningDecorator(executorService);
        return listeningDecorator;
    }

    static Executor rejectionPropagatingExecutor(final Executor executor, final AbstractFuture<?> abstractFuture) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(abstractFuture);
        if (executor == MoreExecutors.directExecutor()) {
            return executor;
        }
        Executor executor2 = new Executor(){

            @Override
            public void execute(Runnable runnable) {
                try {
                    executor.execute(runnable);
                    return;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    abstractFuture.setException(rejectedExecutionException);
                    return;
                }
            }
        };
        return executor2;
    }

    private static final class ScheduledListeningDecorator
    extends ListeningDecorator
    implements ScheduledExecutorService,
    ListeningExecutorService {
        final ScheduledExecutorService delegate;

        ScheduledListeningDecorator(ScheduledExecutorService scheduledExecutorService) {
            super(scheduledExecutorService);
            this.delegate = Preconditions.checkNotNull(scheduledExecutorService);
        }

        public ListenableScheduledFuture<?> schedule(Runnable trustedListenableFutureTask, long l, TimeUnit object) {
            trustedListenableFutureTask = TrustedListenableFutureTask.create(trustedListenableFutureTask, null);
            Object object2 = ((ScheduledListeningDecorator)object2).delegate;
            object2 = object2.schedule(trustedListenableFutureTask, l, (TimeUnit)((Object)object));
            object = new ListenableScheduledTask(trustedListenableFutureTask, (ScheduledFuture<?>)object2);
            return object;
        }

        public <V> ListenableScheduledFuture<V> schedule(Callable<V> object, long l, TimeUnit object2) {
            object = TrustedListenableFutureTask.create(object);
            Object object3 = ((ScheduledListeningDecorator)object3).delegate;
            object3 = object3.schedule((Runnable)object, l, (TimeUnit)((Object)object2));
            object2 = new ListenableScheduledTask(object, (ScheduledFuture<?>)object3);
            return object2;
        }

        public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable listenableScheduledTask, long l, long l2, TimeUnit timeUnit) {
            NeverSuccessfulListenableFutureTask neverSuccessfulListenableFutureTask = new NeverSuccessfulListenableFutureTask((Runnable)((Object)listenableScheduledTask));
            Object object = ((ScheduledListeningDecorator)object).delegate;
            object = object.scheduleAtFixedRate(neverSuccessfulListenableFutureTask, l, l2, timeUnit);
            listenableScheduledTask = new ListenableScheduledTask<Void>(neverSuccessfulListenableFutureTask, (ScheduledFuture<?>)object);
            return listenableScheduledTask;
        }

        public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable listenableScheduledTask, long l, long l2, TimeUnit timeUnit) {
            NeverSuccessfulListenableFutureTask neverSuccessfulListenableFutureTask = new NeverSuccessfulListenableFutureTask((Runnable)((Object)listenableScheduledTask));
            Object object = ((ScheduledListeningDecorator)object).delegate;
            object = object.scheduleWithFixedDelay(neverSuccessfulListenableFutureTask, l, l2, timeUnit);
            listenableScheduledTask = new ListenableScheduledTask<Void>(neverSuccessfulListenableFutureTask, (ScheduledFuture<?>)object);
            return listenableScheduledTask;
        }

        private static final class NeverSuccessfulListenableFutureTask
        extends AbstractFuture.TrustedFuture<Void>
        implements Runnable {
            private final Runnable delegate;

            public NeverSuccessfulListenableFutureTask(Runnable runnable) {
                this.delegate = Preconditions.checkNotNull(runnable);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    this.delegate.run();
                    return;
                }
                catch (Throwable throwable) {
                    this.setException(throwable);
                    throw Throwables.propagate(throwable);
                }
            }
        }

        private static final class ListenableScheduledTask<V>
        extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
        implements ListenableScheduledFuture<V> {
            private final ScheduledFuture<?> scheduledDelegate;

            public ListenableScheduledTask(ListenableFuture<V> listenableFuture, ScheduledFuture<?> scheduledFuture) {
                super(listenableFuture);
                this.scheduledDelegate = scheduledFuture;
            }

            @Override
            public boolean cancel(boolean bl) {
                boolean bl2 = super.cancel(bl);
                if (bl2) {
                    this.scheduledDelegate.cancel(bl);
                }
                return bl2;
            }

            @Override
            public long getDelay(TimeUnit timeUnit) {
                return this.scheduledDelegate.getDelay(timeUnit);
            }

            @Override
            public int compareTo(Delayed delayed) {
                return this.scheduledDelegate.compareTo(delayed);
            }
        }
    }

    private static class ListeningDecorator
    extends AbstractListeningExecutorService {
        private final ExecutorService delegate;

        ListeningDecorator(ExecutorService executorService) {
            this.delegate = Preconditions.checkNotNull(executorService);
        }

        @Override
        public final boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.delegate.awaitTermination(l, timeUnit);
        }

        @Override
        public final boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public final boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public final void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public final List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        @Override
        public final void execute(Runnable runnable) {
            this.delegate.execute(runnable);
        }
    }
}

