/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.FluentFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.InterruptibleTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;

class TrustedListenableFutureTask<V>
extends FluentFuture.TrustedFuture<V>
implements RunnableFuture<V> {
    private volatile InterruptibleTask<?> task;

    static <V> TrustedListenableFutureTask<V> create(Callable<V> callable) {
        TrustedListenableFutureTask<V> trustedListenableFutureTask = new TrustedListenableFutureTask<V>(callable);
        return trustedListenableFutureTask;
    }

    static <V> TrustedListenableFutureTask<V> create(Runnable runnable, V v) {
        TrustedListenableFutureTask<V> trustedListenableFutureTask = new TrustedListenableFutureTask<V>(Executors.callable(runnable, v));
        return trustedListenableFutureTask;
    }

    TrustedListenableFutureTask(Callable<V> callable) {
        TrustedFutureInterruptibleTask trustedFutureInterruptibleTask;
        this.task = trustedFutureInterruptibleTask = new TrustedFutureInterruptibleTask(callable);
    }

    @Override
    public void run() {
        InterruptibleTask<?> interruptibleTask = this.task;
        if (interruptibleTask != null) {
            interruptibleTask.run();
        }
        this.task = null;
    }

    @Override
    protected void afterDone() {
        InterruptibleTask<?> interruptibleTask;
        super.afterDone();
        if (this.wasInterrupted() && (interruptibleTask = this.task) != null) {
            interruptibleTask.interruptTask();
        }
        this.task = null;
    }

    @Override
    protected String pendingToString() {
        InterruptibleTask<?> interruptibleTask = ((TrustedListenableFutureTask)((Object)string)).task;
        if (interruptibleTask != null) {
            String string = String.valueOf(interruptibleTask);
            interruptibleTask = String.valueOf(string);
            int n = ((String)((Object)interruptibleTask)).length();
            StringBuilder stringBuilder = new StringBuilder(n + 7);
            return stringBuilder.append("task=[").append(string).append("]").toString();
        }
        return super.pendingToString();
    }

    private final class TrustedFutureInterruptibleTask
    extends InterruptibleTask<V> {
        private final Callable<V> callable;

        TrustedFutureInterruptibleTask(Callable<V> callable) {
            this.callable = Preconditions.checkNotNull(callable);
        }

        @Override
        final boolean isDone() {
            return TrustedListenableFutureTask.this.isDone();
        }

        @Override
        V runInterruptibly() throws Exception {
            return this.callable.call();
        }

        @Override
        void afterRanInterruptiblySuccess(V v) {
            TrustedListenableFutureTask.this.set(v);
        }

        @Override
        void afterRanInterruptiblyFailure(Throwable throwable) {
            TrustedListenableFutureTask.this.setException(throwable);
        }

        @Override
        String toPendingString() {
            return this.callable.toString();
        }
    }
}

