/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.Stage;

public final class ActivityLifecycles {
    private ActivityLifecycles() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasForegroundActivities(ActivityLifecycleMonitor monitor) {
        if (monitor.getActivitiesInStage(Stage.RESUMED).isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasVisibleActivities(ActivityLifecycleMonitor monitor) {
        ActivityLifecycleMonitor activityLifecycleMonitor;
        if (ActivityLifecycles.hasForegroundActivities(monitor)) return true;
        if (!ActivityLifecycles.hasTransitioningActivities(activityLifecycleMonitor)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasTransitioningActivities(ActivityLifecycleMonitor monitor) {
        ActivityLifecycleMonitor activityLifecycleMonitor;
        if (!monitor.getActivitiesInStage(Stage.RESTARTED).isEmpty()) return true;
        if (!activityLifecycleMonitor.getActivitiesInStage(Stage.STARTED).isEmpty()) return true;
        if (activityLifecycleMonitor.getActivitiesInStage(Stage.PAUSED).isEmpty()) return false;
        return true;
    }
}

