/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import android.content.res.Resources;
import android.database.Cursor;
import android.os.Build;
import android.util.Printer;
import android.util.StringBuilderPrinter;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.Checkable;
import android.widget.TextView;
import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Joiner;
import androidx.test.espresso.core.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Strings;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.util.TreeIterables;
import java.util.List;
import java.util.Locale;

public final class HumanReadables {
    private HumanReadables() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static String getViewHierarchyErrorMessage(View rootView, List<View> problemViews, String errorHeader, String problemViewSuffix) {
        void var1_4;
        View view;
        Object[] objectArray;
        Object object;
        void var3_6;
        boolean bl = problemViews == null || var3_6 != null;
        Preconditions.checkArgument(bl);
        StringBuilder stringBuilder = new StringBuilder((String)object);
        if (var3_6 != null) {
            object = Locale.ROOT;
            objectArray = new Object[]{var3_6};
            stringBuilder.append(String.format((Locale)object, "\nProblem views are marked with '%s' below.", objectArray));
        }
        object = Joiner.on("\n|\n");
        Iterable<TreeIterables.ViewAndDistance> iterable = TreeIterables.depthFirstViewTraversalWithDistance(view);
        objectArray = new Function<TreeIterables.ViewAndDistance, String>((List)var1_4, (String)var3_6){
            final /* synthetic */ List val$problemViews;
            final /* synthetic */ String val$problemViewSuffix;
            {
                this.val$problemViews = list;
                this.val$problemViewSuffix = string;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            public String apply(TreeIterables.ViewAndDistance viewAndDistance) {
                Object object;
                void var1_1;
                Object object2 = "+%s%s ";
                if (object.val$problemViews != null) {
                    if (object.val$problemViews.contains(var1_1.getView())) {
                        object2 = String.valueOf(object2);
                        object = String.valueOf(object.val$problemViewSuffix);
                        object = ((String)object).length() != 0 ? ((String)object2).concat((String)object) : new String((String)object2);
                    } else {
                        object = object2;
                    }
                } else {
                    object = object2;
                }
                object2 = Locale.ROOT;
                Object[] objectArray = new Object[]{Strings.padStart(">", var1_1.getDistanceFromRoot() + 1, '-'), HumanReadables.describe(var1_1.getView())};
                return String.format((Locale)object2, (String)object, objectArray);
            }
        };
        Iterable iterable2 = Iterables.transform(iterable, objectArray);
        String string = ((Joiner)object).join(iterable2);
        stringBuilder.append("\n\nView Hierarchy:\n").append(string);
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String describe(Cursor c) {
        if (c.isBeforeFirst()) {
            return "Cursor positioned before first element.";
        }
        if (var0.isAfterLast()) {
            return "Cursor positioned after last element.";
        }
        var1_1 = new StringBuilder("Row ");
        var3_3 = var1_1.append(var0.getPosition()).append(": {");
        var4_4 = var0.getColumnNames();
        block7: for (var1_2 = 0; var1_2 < var4_4.length; ++var1_2) {
            block13: {
                var3_3.append(var4_4[var1_2]).append(":");
                if (Build.VERSION.SDK_INT <= 10) break block13;
                switch (var0.getType(var1_2)) {
                    default: {
                        var3_3.append("\"").append(var0.getString(var1_2)).append("\"");
lbl16:
                        // 6 sources

                        while (true) {
                            var3_3.append(", ");
                            continue block7;
                            break;
                        }
                    }
                    case 4: {
                        var5_6 = var0.getBlob(var1_2);
                        var3_3.append("[");
                        for (var2_5 = 0; var2_5 < 5 && var2_5 < var5_6.length; ++var2_5) {
                            var3_3.append(var5_6[var2_5]);
                            var3_3.append(",");
                        }
                        if (var5_6.length > 5) {
                            var3_3.append("... (").append(var5_6.length + -5).append(" more elements)");
                        }
                        var3_3.append("]");
                        ** GOTO lbl16
                    }
                    case 2: {
                        var3_3.append(var0.getDouble(var1_2));
                        var3_3.append("f");
                        ** GOTO lbl16
                    }
                    case 1: {
                        var3_3.append(var0.getLong(var1_2));
                        ** GOTO lbl16
                    }
                    case 0: {
                        var3_3.append("null");
                        ** GOTO lbl16
                    }
                    case 3: 
                }
            }
            var3_3.append("\"").append(var0.getString(var1_2)).append("\"");
            ** continue;
        }
        var3_3.append("}");
        return var3_3.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String describe(View v) {
        EditorInfo editorInfo;
        View view;
        if (v == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(view).add("id", view.getId());
        if (view.getId() != -1 && view.getResources() != null && !HumanReadables.isViewIdGenerated(view.getId())) {
            try {
                toStringHelper.add("res-name", view.getResources().getResourceEntryName(view.getId()));
            }
            catch (Resources.NotFoundException notFoundException) {}
        }
        if (view.getContentDescription() != null) {
            toStringHelper.add("desc", view.getContentDescription());
        }
        switch (view.getVisibility()) {
            default: {
                toStringHelper.add("visibility", view.getVisibility());
                break;
            }
            case 8: {
                toStringHelper.add("visibility", "GONE");
                break;
            }
            case 4: {
                toStringHelper.add("visibility", "INVISIBLE");
                break;
            }
            case 0: {
                toStringHelper.add("visibility", "VISIBLE");
            }
        }
        toStringHelper.add("width", view.getWidth()).add("height", view.getHeight()).add("has-focus", view.hasFocus()).add("has-focusable", view.hasFocusable()).add("has-window-focus", view.hasWindowFocus()).add("is-clickable", view.isClickable()).add("is-enabled", view.isEnabled()).add("is-focused", view.isFocused()).add("is-focusable", view.isFocusable()).add("is-layout-requested", view.isLayoutRequested()).add("is-selected", view.isSelected()).add("layout-params", view.getLayoutParams()).add("tag", view.getTag());
        if (view.getRootView() != null) {
            toStringHelper.add("root-is-layout-requested", view.getRootView().isLayoutRequested());
        }
        boolean bl = view.onCreateInputConnection(editorInfo = new EditorInfo()) != null;
        toStringHelper.add("has-input-connection", bl);
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            StringBuilderPrinter stringBuilderPrinter = new StringBuilderPrinter(stringBuilder);
            editorInfo.dump((Printer)stringBuilderPrinter, "");
            stringBuilder.append("]");
            toStringHelper.add("editor-info", stringBuilder.toString().replace("\n", " "));
        }
        if (Build.VERSION.SDK_INT > 10) {
            toStringHelper.add("x", view.getX()).add("y", view.getY());
        }
        if (view instanceof TextView) {
            HumanReadables.innerDescribe((TextView)view, toStringHelper);
        }
        if (view instanceof Checkable) {
            HumanReadables.innerDescribe((Checkable)view, toStringHelper);
        }
        if (view instanceof ViewGroup) {
            HumanReadables.innerDescribe((ViewGroup)view, toStringHelper);
        }
        return toStringHelper.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void innerDescribe(TextView textBox, MoreObjects.ToStringHelper helper) {
        TextView textView;
        void var1_2;
        if (textBox.getText() != null) {
            var1_2.add("text", textView.getText());
        }
        if (textView.getError() != null) {
            var1_2.add("error-text", textView.getError());
        }
        if (textView.getHint() != null) {
            var1_2.add("hint", textView.getHint());
        }
        var1_2.add("input-type", textView.getInputType());
        var1_2.add("ime-target", textView.isInputMethodTarget());
        boolean bl = textView.getUrls().length > 0;
        var1_2.add("has-links", bl);
    }

    private static void innerDescribe(Checkable checkable, MoreObjects.ToStringHelper helper) {
        Checkable checkable2;
        helper.add("is-checked", checkable2.isChecked());
    }

    private static void innerDescribe(ViewGroup viewGroup, MoreObjects.ToStringHelper helper) {
        ViewGroup viewGroup2;
        helper.add("child-count", viewGroup2.getChildCount());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isViewIdGenerated(int id) {
        int n;
        if ((id & 0xFF000000) != 0) return 0 != 0;
        if ((n & 0xFFFFFF) == 0) return 0 != 0;
        return 1 != 0;
    }
}

