/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import android.view.View;
import android.view.ViewGroup;
import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.AbstractIterator;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class TreeIterables {
    private static final TreeViewer<View> VIEW_TREE_VIEWER;

    private TreeIterables() {
    }

    public static Iterable<ViewAndDistance> depthFirstViewTraversalWithDistance(View root) {
        Object object;
        final DistanceRecordingTreeViewer<View> distanceRecordingTreeViewer = new DistanceRecordingTreeViewer<View>((View)object, VIEW_TREE_VIEWER);
        object = TreeIterables.depthFirstTraversal(object, distanceRecordingTreeViewer);
        Function<View, ViewAndDistance> function = new Function<View, ViewAndDistance>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public ViewAndDistance apply(View view) {
                void var1_1;
                ViewAndDistance viewAndDistance = new ViewAndDistance((View)var1_1, distanceRecordingTreeViewer.getDistance(var1_1));
                return viewAndDistance;
            }
        };
        return Iterables.transform(object, function);
    }

    public static Iterable<View> depthFirstViewTraversal(View root) {
        return TreeIterables.depthFirstTraversal(root, VIEW_TREE_VIEWER);
    }

    public static Iterable<View> breadthFirstViewTraversal(View root) {
        return TreeIterables.breadthFirstTraversal(root, VIEW_TREE_VIEWER);
    }

    /*
     * WARNING - void declaration
     */
    static <T> Iterable<T> depthFirstTraversal(T root, TreeViewer<T> viewer) {
        T t;
        void var1_1;
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(var1_1);
        TreeTraversalIterable treeTraversalIterable = new TreeTraversalIterable(t, TraversalStrategy.DEPTH_FIRST, (TreeViewer)var1_1);
        return treeTraversalIterable;
    }

    /*
     * WARNING - void declaration
     */
    static <T> Iterable<T> breadthFirstTraversal(T root, TreeViewer<T> viewer) {
        T t;
        void var1_1;
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(var1_1);
        TreeTraversalIterable treeTraversalIterable = new TreeTraversalIterable(t, TraversalStrategy.BREADTH_FIRST, (TreeViewer)var1_1);
        return treeTraversalIterable;
    }

    static {
        ViewTreeViewer viewTreeViewer;
        VIEW_TREE_VIEWER = viewTreeViewer = new ViewTreeViewer();
    }

    public static class ViewAndDistance {
        private final View view;
        private final int distanceFromRoot;

        /*
         * WARNING - void declaration
         */
        private ViewAndDistance(View view, int distanceFromRoot) {
            void var2_2;
            void var1_1;
            this.view = var1_1;
            this.distanceFromRoot = var2_2;
        }

        public View getView() {
            return this.view;
        }

        public int getDistanceFromRoot() {
            return this.distanceFromRoot;
        }
    }

    static interface TreeViewer<T> {
        public Collection<T> children(T var1);
    }

    static class DistanceRecordingTreeViewer<T>
    implements TreeViewer<T> {
        private final T root;
        private final Map<T, Integer> nodeToDistance = Maps.newHashMap();
        private final TreeViewer<T> delegateViewer;

        /*
         * WARNING - void declaration
         */
        DistanceRecordingTreeViewer(T root, TreeViewer<T> delegateViewer) {
            void var2_2;
            void var1_1;
            this.root = Preconditions.checkNotNull(var1_1);
            this.delegateViewer = (TreeViewer)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        int getDistance(T node) {
            void var1_1;
            return Preconditions.checkNotNull(this.nodeToDistance.get(var1_1), "Never seen %s before", var1_1);
        }

        @Override
        public Collection<T> children(T node) {
            Collection<void> collection;
            if (node == this.root) {
                this.nodeToDistance.put(collection, 0);
            }
            int n = this.getDistance(collection) + 1;
            collection = this.delegateViewer.children((void)collection);
            for (void var4_4 : collection) {
                this.nodeToDistance.put(var4_4, n);
            }
            return collection;
        }
    }

    static class ViewTreeViewer
    implements TreeViewer<View> {
        ViewTreeViewer() {
        }

        @Override
        public Collection<View> children(View view) {
            ViewGroup viewGroup;
            Preconditions.checkNotNull(view);
            if (viewGroup instanceof ViewGroup) {
                viewGroup = viewGroup;
                int n = viewGroup.getChildCount();
                ArrayList<View> arrayList = Lists.newArrayList();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(viewGroup.getChildAt(i));
                }
                return arrayList;
            }
            return Collections.emptyList();
        }
    }

    private static abstract class TraversalStrategy
    extends Enum<TraversalStrategy> {
        public static final /* enum */ TraversalStrategy BREADTH_FIRST;
        public static final /* enum */ TraversalStrategy DEPTH_FIRST;
        private static final /* synthetic */ TraversalStrategy[] $VALUES;

        public static TraversalStrategy[] values() {
            return (TraversalStrategy[])$VALUES.clone();
        }

        public static TraversalStrategy valueOf(String name) {
            String string;
            return Enum.valueOf(TraversalStrategy.class, string);
        }

        abstract <T> void combineNewChildren(LinkedList<T> var1, Collection<T> var2);

        <T> T next(LinkedList<T> nodes) {
            return nodes.removeFirst();
        }

        static {
            TraversalStrategy traversalStrategy = new TraversalStrategy(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                <T> void combineNewChildren(LinkedList<T> nodes, Collection<T> newChildren) {
                    void var2_2;
                    nodes.addAll((Collection<T>)var2_2);
                }
            };
            BREADTH_FIRST = traversalStrategy;
            traversalStrategy = new TraversalStrategy(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                <T> void combineNewChildren(LinkedList<T> nodes, Collection<T> newChildren) {
                    void var2_2;
                    nodes.addAll(0, (Collection<T>)var2_2);
                }
            };
            DEPTH_FIRST = traversalStrategy;
            $VALUES = traversalStrategyArray = new TraversalStrategy[]{TraversalStrategy.BREADTH_FIRST, TraversalStrategy.DEPTH_FIRST};
        }
    }

    private static class TreeTraversalIterable<T>
    implements Iterable<T> {
        private final T root;
        private final TraversalStrategy traversalStrategy;
        private final TreeViewer<T> treeViewer;

        /*
         * WARNING - void declaration
         */
        private TreeTraversalIterable(T root, TraversalStrategy traversalStrategy, TreeViewer<T> treeViewer) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.root = Preconditions.checkNotNull(var1_1);
            this.traversalStrategy = (TraversalStrategy)Preconditions.checkNotNull(var2_2);
            this.treeViewer = (TreeViewer)Preconditions.checkNotNull(var3_3);
        }

        @Override
        public Iterator<T> iterator() {
            LinkedList<T> linkedList = Lists.newLinkedList();
            linkedList.add(this.root);
            AbstractIterator abstractIterator = new AbstractIterator<T>(this, linkedList){
                final /* synthetic */ LinkedList val$nodes;
                final /* synthetic */ TreeTraversalIterable this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$nodes = linkedList;
                }

                @Override
                public T computeNext() {
                    if (this.val$nodes.isEmpty()) {
                        return this.endOfData();
                    }
                    Object t = Preconditions.checkNotNull(this.this$0.traversalStrategy.next(this.val$nodes), "Null items not allowed!");
                    this.this$0.traversalStrategy.combineNewChildren(this.val$nodes, this.this$0.treeViewer.children(t));
                    return t;
                }
            };
            return abstractIterator;
        }
    }
}

