/*
 * Decompiled with CFR 0.152.
 */
package appscanstdrdintegration.appscanstandard;

import appscanstdrdintegration.appscanstandard.AppScanStandardCommand;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class AppScanStandardInstallation
extends ToolInstallation {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public AppScanStandardInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public AppScanStandardInstallation forEnvironment(EnvVars environment) {
        return new AppScanStandardInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public AppScanStandardInstallation forNode(Node node, TaskListener log) throws InterruptedException {
        try {
            return new AppScanStandardInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
        }
        catch (IOException e) {
            Logger logger = Logger.getAnonymousLogger();
            logger.log(Level.SEVERE, "AppScan Standard not found on selected node.", e);
            log.getLogger().println("Verify that AppScan Standard is installed in the selected node.");
            return null;
        }
    }

    public static String getExecutable(String name, AppScanStandardCommand command, Node node, TaskListener listener, EnvVars env) throws InterruptedException {
        Jenkins j = Jenkins.getInstance();
        if (j == null || StringUtils.isEmpty((String)name)) {
            return command.getName();
        }
        for (AppScanStandardInstallation tool : (AppScanStandardInstallation[])((DescriptorImpl)j.getDescriptorByType(DescriptorImpl.class)).getInstallations()) {
            if (!tool.getName().equals(name)) continue;
            if (node != null) {
                tool = tool.forNode(node, listener);
            }
            if (env != null) {
                tool = tool.forEnvironment(env);
            }
            String home = Util.fixEmpty((String)tool.getHome());
            return AppScanStandardInstallation.validateCommand(home, node, command);
        }
        return command.getName();
    }

    public static String validateCommand(String home, Node node, AppScanStandardCommand command) {
        if (home != null) {
            FilePath homePath;
            if (node != null && (homePath = node.createPath(home)) != null) {
                return homePath.child(command.getName()).getRemote();
            }
            return home + "/" + command.getName();
        }
        return command.getName();
    }

    public static AppScanStandardInstallation[] allInstallations() {
        AppScanStandardInstallation[] installations = new AppScanStandardInstallation[]{};
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            installations = (AppScanStandardInstallation[])((DescriptorImpl)jenkins.getDescriptorByType(DescriptorImpl.class)).getInstallations();
        }
        return installations;
    }

    public static AppScanStandardInstallation getInstallation(String appScanStandardInstallation) throws IOException {
        AppScanStandardInstallation[] installations = AppScanStandardInstallation.allInstallations();
        if (appScanStandardInstallation == null) {
            if (installations.length == 0) {
                throw new IOException("AppScan Standard not found");
            }
            return installations[0];
        }
        for (AppScanStandardInstallation installation : installations) {
            if (!appScanStandardInstallation.equals(installation.getName())) continue;
            return installation;
        }
        throw new IOException("AppScan Standard not found");
    }

    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<AppScanStandardInstallation> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            super.configure(req, json);
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "AppScan Standard";
        }
    }
}

