/*
 * Decompiled with CFR 0.152.
 */
package appscanstdrintegration.appscanstandard.utilities;

import hudson.FilePath;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.jfree.util.Log;

public class AppScanStandardManualExploreFile {
    private final String includeURLS;
    private FilePath tempFile;
    private PrintStream logger;
    private StringBuilder sb;

    public AppScanStandardManualExploreFile(String includeURLS, PrintStream logger) {
        this.includeURLS = includeURLS;
        this.logger = logger;
    }

    public void createManualExploreFile(FilePath ws) {
        this.sb = new StringBuilder();
        String[] urlsToInclude = this.includeURLS.split("\n");
        this.sb.append("<?xml version='1.0' encoding='UTF-8'?>" + System.lineSeparator() + "<!-- Automatically created by AppScan -->" + System.lineSeparator() + "<!-- Do NOT Edit! -->" + System.lineSeparator() + "<requests>" + System.lineSeparator());
        for (int i = 0; i < urlsToInclude.length; ++i) {
            if (urlsToInclude[i].isEmpty()) continue;
            this.createGETRequests(urlsToInclude[i]);
        }
        this.sb.append("</requests>");
        try {
            this.tempFile = ws.createTextTempFile("manual_explore_file", ".exd", this.sb.toString());
        }
        catch (IOException | InterruptedException e) {
            Log.error((Object)("Exception creating temporary text file for manual explore." + e));
        }
    }

    public void createGETRequests(String sURL) {
        URI inc = null;
        try {
            int port;
            inc = new URI(sURL);
            String path = inc.getPath();
            if ("".equals(path)) {
                path = "/";
            }
            if ((port = inc.getPort()) < 0) {
                port = 80;
            }
            String query = "";
            if (inc.getQuery() != null) {
                query = "?" + inc.getQuery();
            }
            this.sb.append("<request scheme=\"" + inc.getScheme() + "\" host=\"" + inc.getHost() + "\" path=\"" + path + query + "\" port=\"" + port + "\" method=\"GET\">" + System.lineSeparator() + "<raw>GET " + path + "?" + query + " HTTP/1.1" + System.lineSeparator() + "Accept: */*" + System.lineSeparator() + "Accept-Language: en-US,he;q=0.5" + System.lineSeparator() + "User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; .NET4.0E; MS-RTC LM 8)" + System.lineSeparator() + "Connection: Keep-Alive" + System.lineSeparator() + "Host: " + inc.getHost() + ":" + port + System.lineSeparator() + "Content-Length: 0" + System.lineSeparator() + System.lineSeparator() + "</raw>" + System.lineSeparator() + "</request>" + System.lineSeparator());
        }
        catch (URISyntaxException e) {
            Log.error((Object)("Exception converting string to URI." + e));
            this.logger.println("Invalid URL: [ " + sURL + " ] skipping it.");
        }
    }

    public String getManualExploreFileLocation() {
        return this.tempFile.getRemote();
    }

    public void deleteManualExploreFile() {
        try {
            this.tempFile.delete();
        }
        catch (IOException | InterruptedException e) {
            Log.error((Object)("Exception deleting  temporary text file for manual explore." + e));
        }
    }
}

