/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.client.message.connect;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.message.AbstractMessageHeader;

@StampyLibrary(libraryName="stampy-core")
public class ConnectHeader
extends AbstractMessageHeader {
    private static final long serialVersionUID = 6732326426523759109L;
    public static final String HEART_BEAT = "heart-beat";
    public static final String PASSCODE = "passcode";
    public static final String LOGIN = "login";
    public static final String HOST = "host";
    public static final String ACCEPT_VERSION = "accept-version";

    public void setAcceptVersion(String acceptVersion) {
        this.addHeader(ACCEPT_VERSION, acceptVersion);
    }

    public String getAcceptVersion() {
        return this.getHeaderValue(ACCEPT_VERSION);
    }

    public void setHost(String host) {
        this.addHeader(HOST, host);
    }

    public String getHost() {
        return this.getHeaderValue(HOST);
    }

    public void setLogin(String user) {
        this.addHeader(LOGIN, user);
    }

    public String getLogin() {
        return this.getHeaderValue(LOGIN);
    }

    public void setPasscode(String passcode) {
        this.addHeader(PASSCODE, passcode);
    }

    public String getPasscode() {
        return this.getHeaderValue(PASSCODE);
    }

    public void setHeartbeat(int outgoingHeartbeat, int incomingHeartbeat) {
        this.addHeader(HEART_BEAT, Integer.toString(outgoingHeartbeat) + "," + Integer.toString(incomingHeartbeat));
    }

    public int getOutgoingHeartbeat() {
        return this.getHeartbeat(0);
    }

    public int getIncomingHeartbeat() {
        return this.getHeartbeat(1);
    }

    private int getHeartbeat(int pos) {
        String hb = this.getHeaderValue(HEART_BEAT);
        if (hb == null) {
            return 0;
        }
        String[] parts = hb.split(",");
        return Integer.parseInt(parts[pos]);
    }
}

