/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.client.message.subscribe;

import asia.stampy.client.message.AbstractClientMessageHeader;
import asia.stampy.common.StampyLibrary;

@StampyLibrary(libraryName="stampy-core")
public class SubscribeHeader
extends AbstractClientMessageHeader {
    private static final long serialVersionUID = 2321658220170938363L;
    public static final String ID = "id";
    public static final String ACK = "ack";
    public static final String DESTINATION = "destination";

    public void setDestination(String destination) {
        this.addHeader(DESTINATION, destination);
    }

    public String getDestination() {
        return this.getHeaderValue(DESTINATION);
    }

    public void setAck(Ack ack) {
        this.addHeader(ACK, ack.getAckValue());
    }

    public Ack getAck() {
        String s = this.getHeaderValue(ACK);
        if (s == null) {
            return null;
        }
        return Ack.fromString(s);
    }

    public void setId(String id) {
        this.addHeader(ID, id);
    }

    public String getId() {
        return this.getHeaderValue(ID);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Ack {
        auto("auto"),
        client("client"),
        clientIndividual("client-individual");

        String ackValue;

        private Ack(String ackValue) {
            this.ackValue = ackValue;
        }

        public String getAckValue() {
            return this.ackValue;
        }

        public static Ack fromString(String s) {
            for (Ack ack : Ack.values()) {
                if (!ack.getAckValue().equals(s)) continue;
                return ack;
            }
            return null;
        }
    }
}

