/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.message;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.message.AbstractBodyMessageHeader;
import asia.stampy.common.message.AbstractMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.common.serialization.SerializationUtils;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-core")
public abstract class AbstractBodyMessage<HDR extends AbstractBodyMessageHeader>
extends AbstractMessage<HDR> {
    private static final long serialVersionUID = 3988865546656906553L;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String JAVA_BASE64_MIME_TYPE = "java/base64";
    private String bodyEncoding = "java/base64";
    private Object body;

    protected AbstractBodyMessage(StompMessageType messageType) {
        super(messageType);
    }

    public <O> O getBody() {
        return (O)this.body;
    }

    public <O> void setBody(O body) {
        this.body = body;
    }

    public void setMimeType(String mimeType) {
        ((AbstractBodyMessageHeader)this.getHeader()).setContentType(mimeType);
    }

    public void setMimeType(String mimeType, String encoding) {
        mimeType = mimeType + ";charset=" + encoding;
        this.setMimeType(mimeType);
    }

    public boolean isText() {
        String value = ((AbstractBodyMessageHeader)this.getHeader()).getContentType();
        if (value == null) {
            return true;
        }
        return value.contains("text/");
    }

    @Override
    protected String postHeader() {
        if (this.getBody() == null) {
            return null;
        }
        if (this.isText()) {
            return (String)this.getBody();
        }
        try {
            String encoded = this.getBodyEncoding().equals(JAVA_BASE64_MIME_TYPE) ? this.getObjectArrayAsBase64(this.getBody()) : this.getObjectArrayAsString(this.getBody());
            ((AbstractBodyMessageHeader)this.getHeader()).removeHeader("content-type");
            ((AbstractBodyMessageHeader)this.getHeader()).removeHeader("content-length");
            ((AbstractBodyMessageHeader)this.getHeader()).setContentLength(encoded.length());
            ((AbstractBodyMessageHeader)this.getHeader()).setContentType(this.getBodyEncoding());
            return encoded;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getObjectArrayAsString(Object body) {
        throw new NotImplementedException("Subclass the abstract body message and override getObjectArrayAsString for " + this.getBodyEncoding() + " encoding");
    }

    public String getObjectArrayAsBase64(Object o) throws IOException {
        log.debug("Serializing object to a string using Base64 encoding", o);
        return SerializationUtils.serializeBase64(o);
    }

    public String getBodyEncoding() {
        return this.bodyEncoding;
    }

    public void setBodyEncoding(String bodyEncoding) {
        this.bodyEncoding = bodyEncoding;
    }
}

